package com.ejianc.basem.service.impl;

import com.beust.jcommander.internal.Lists;
import com.ejianc.basem.bean.ActRuTaskPo;
import com.ejianc.basem.service.IActRuExecutionService;
import com.ejianc.basem.utils.ToolUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.ztpcdata.api.IExternalApi;
import com.ejianc.ztpcdata.vo.ActRuTaskVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Classname ActRuExecutionService
 * @Description TODO
 * @Date 2023/4/27 15:33
 * @Created by lijunxue
 */
@Service("actRuTaskService")
public class ActRuTaskService implements IActRuExecutionService {
    @Autowired
    private IExternalApi iExternalApi;


    /**
     * 根据业务id获取到当前节点信息
     *
     * @param businessKey
     * @return
     */
    public List<ActRuTaskPo> getActRuTaskPo(String businessKey) {
        CommonResponse<List<ActRuTaskVO>> response = iExternalApi.getByBizKey(businessKey);
        if (response.isSuccess()) {
            return BeanMapper.mapList(response.getData(), ActRuTaskPo.class);
        }
        return null;
    }

    /**
     * 根据业务id 在会签的时候 获取到还有多少节点的任务没有完成
     *
     * @param businessKey
     * @return
     */
    public List<String> getListNodeType(String businessKey) {
        List<ActRuTaskPo> actRuTaskPos = Lists.newArrayList();
        CommonResponse<List<ActRuTaskVO>> response = iExternalApi.getByBizKey(businessKey);
        if (response.isSuccess()) {
            actRuTaskPos = BeanMapper.mapList(response.getData(), ActRuTaskPo.class);
        }
        if (ToolUtil.isNotEmpty(actRuTaskPos) && actRuTaskPos.size() > 1) {
            List<String> collect = actRuTaskPos.stream().map(ActRuTaskPo::getDescription).collect(Collectors.toList());
            return collect;
        } else {
            return Arrays.asList("ERROR");
        }
    }

}
