package com.ejianc.business.ztpczr.jwt;

import java.io.Serializable;
import java.util.List;

/**
 * Created  on 2017/9/10.
 */
public class JWTInfo implements Serializable, IJWTInfo {
    private String username;
    private String userId;
    private String name;
    private String dept;
    private List<String> roles;
    private String orgCode;
    private String projectCode;

    public JWTInfo(String username, String userId, String name, String dept, List<String> roles,String orgCode,String projectCode) {
        this.username = username;
        this.userId = userId;
        this.name = name;
        this.dept = dept;
        this.roles = roles;
        this.orgCode = orgCode;
        this.projectCode = projectCode;
    }


    @Override
    public String getUniqueName() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String getDept() {
        return dept;
    }

    @Override
    public String getOrgCode() {
        return orgCode;
    }

    @Override
    public String getProjectCode() {
        return projectCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    @Override
    public List<String> getRoles() {
        return roles;
    }

    public void setDept(String dept) {
        this.dept = dept;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        JWTInfo jwtInfo = (JWTInfo) o;

        if (username != null ? !username.equals(jwtInfo.username) : jwtInfo.username != null) {
            return false;
        }
        return userId != null ? userId.equals(jwtInfo.userId) : jwtInfo.userId == null;

    }

    @Override
    public int hashCode() {
        int result = username != null ? username.hashCode() : 0;
        result = 31 * result + (userId != null ? userId.hashCode() : 0);
        return result;
    }
}
