package com.ejianc.business.ztpczr.service.impl;

import com.ejianc.basem.utils.ToolUtil;
import com.ejianc.business.ztpczr.jwt.RsaKeyHelper;
import com.ejianc.business.ztpczr.service.JwtService;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JwtServiceImpl implements JwtService {

    @Autowired
    private IUserApi userApi;


    public static String key = "MIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAKR1+9jb+aagmgku8GGUV84Bhxpr8j0ucqVz4KsXeaZ8zYmQOX+sqXwbH/Wk6WZTGt3/SKTdBRjFfUlmMexq2vKYld03Y7dqb5c2na1+w4e1ywEBqONmUz90XqSrZrR1NOKV91ney4Gx858NJZAWCwKOhWPqmXuOMh+NhXAGO77/AgMBAAECgYAyMZg17Z1aT7Xzi5HuFjpeM3UqiTublKuE98LgNP/54ilRDOWfo/DuYdD1Rem+Qyr2Ck3/kz1U/CFq33fpMgu0dYj9ihglK3pbLadG9L+Vss9uPPU/B+EbS4p/I1+MewHqipfQarZjxPiEqra+rcCkCywXXdH4UIeMqYNci2iBoQJBANnCEGd+ISFcxVVrZPAIxXP1ZhXqe1byLetXkx8NfC21e6gD287WCLh2imbm7iPOPQqJx9LP7eZ10qIDkrv0KTkCQQDBV8rTxB1x2za7xGLE3HcFb4JXpMIL2E/bU3fc5RYMY1phVwCaQGPdZ47PabH9Td+M8LLF/IQgZ1PKxJITNMH3AkAJihXb4suiwYSnjE/csBWuUcbKGP6UPYHDeI+qYZXaDsQ/BQRBGGFDa3X+sgkmqmdEKesGEjPSz8CNdmicMUMJAkAuYQn1nKDXlBdgGW77/ErM0f/5WDt4Le6SFUa2hXmxhQ/EM+OgHPwXu2TFmnwo4EpU+9RWrAlh4Id4J4lG9CvnAkEApQgV1KI/OdbJBa+kaWslQ530HlgE5+/yLzXHVcduBSL8vkVNZwH2a2urtSY+m3HPC1vFhro3LmeG6SZGla/nvw==";
    private static RsaKeyHelper rsaKeyHelper = new RsaKeyHelper();

    @Override
    public String generateToken() throws Exception {
        Long userid = InvocationInfoProxy.getUserid();
        CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(userid);
        if (ToolUtil.isNotEmpty(userByUserId.getData())&&userByUserId.isSuccess()){
        String compactJws = Jwts.builder()
                .setSubject(userByUserId.getData().getUserCode())
                .claim("tenantId", "3B6EE02B66984A90917C82108B3AB2B4")
                .claim("cz", "cczz")
                .claim("jobNumber", userByUserId.getData().getUserCode())
                .claim("phone", userByUserId.getData().getUserMobile())
                .claim("timestamp", System.currentTimeMillis())
                .setExpiration(DateTime.now().plusSeconds(3600).toDate()) //180
                .signWith(SignatureAlgorithm.RS256, rsaKeyHelper.getPrivateKey(RsaKeyHelper.toBytes(key)))
                .compact();
        return compactJws;
        }
        throw new Exception("用户信息查找不到");
    }
}
