package com.ejianc.business.ztpczr.service.impl;

import com.ejianc.business.ztpczr.bean.Button1Entity;
import com.ejianc.business.ztpczr.service.IButtonService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.ztpcdata.api.IExternalApi;
import com.ejianc.ztpcdata.vo.ButtonVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 按钮管理
 *
 * @author generator
 */
@Service("buttonService")
public class ButtonServiceImpl implements IButtonService {
    @Autowired
    private IExternalApi iExternalApi;


    @Override
    public List<Button1Entity> selectButton(Map<String, Object> params) {
        CommonResponse<List<ButtonVO>> response = iExternalApi.getButton(params);
        if (response.isSuccess()) {
            return BeanMapper.mapList(response.getData(), Button1Entity.class);
        }
        return null;
    }

    @Override
    public int selectButtonCount() {
        CommonResponse<Integer> response = iExternalApi.getButtonCount();
        if (response.isSuccess()) {
            return response.getData();
        }
        return 0;
    }


}
