/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ztpczr.controller;

import com.ejianc.business.ztpczr.bean.DcFileTypeQuery;
import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.business.ztpczr.service.ISystemService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"pubVarConfig"})
public class SystemController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISystemService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/dcFileTypeQueryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> dcFileTypeQueryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("belongOrgId", this.sessionManager.getUserContext().getOrgId());
        if (ToolUtil.isEmpty(pid)) {
            params.put("pid", 1474197986685751299L);
        } else {
            params.put("pid", pid);
        }
        List<Long> inIds = null;
        List<Long> notInIds = null;
        if (ToolUtil.isNotEmpty(condition)) {
            String substring;
            if (condition.startsWith("inIds")) {
                substring = condition.substring("inIds".length());
                inIds = SystemController.getIds(substring);
            }
            if (condition.startsWith("notInIds")) {
                substring = condition.substring("notInIds".length());
                notInIds = SystemController.getIds(substring);
            }
        }
        params.put("inIds", inIds);
        params.put("notInIds", notInIds);
        List<DcFileTypeQuery> dataList = this.service.dcFileTypeQuery(params);
        ArrayList<Long> pidList = new ArrayList<Long>();
        for (DcFileTypeQuery dcFileTypeQuery : dataList) {
            pidList.add(dcFileTypeQuery.getId());
        }
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        if (ToolUtil.isEmpty(pid)) {
            params1.put("pid", "0");
        } else {
            params1.put("pid", pid);
        }
        Long orgId = InvocationInfoProxy.getOrgId();
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            params1.put("belongOrgId", Arrays.asList(orgId));
        } else {
            CommonResponse orgResp = this.iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                this.logger.error("\u5206\u9875\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25, {}", (Object)orgResp.getMsg());
                return new ArrayList<Map<String, Object>>();
            }
            params1.put("belongOrgId", ((List)orgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List<DcFileTypeQuery> dataList1 = this.service.otherFileTypeQuery(params1);
        List map = BeanMapper.mapList(dataList, Map.class);
        List map1 = BeanMapper.mapList(dataList1, Map.class);
        map.addAll(map1);
        return ResultAsTree.createTreeData((List)map);
    }

    public static List<Long> getIds(String ids) {
        if (ToolUtil.isEmpty(ids)) {
            return null;
        }
        List<Long> collect = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        return collect;
    }
}

