package com.ejianc.business.labor.vo;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 人脸信息VO
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
public class FaceInfoVO {
	private static final long serialVersionUID = 315211576969827891L;

	/** 用户id */
	@NotNull(message = "用户id不能为空！", groups = {CustomValidateGroup.Crud.Create.class, CustomValidateGroup.Crud.Query.class})
	private Long userId;
	/** 用户名 */
	@NotBlank(message = "用户名不能为空！", groups = {CustomValidateGroup.Crud.Create.class})
	private String userName;
	/** 身份证号码 */
	@NotBlank(message = "身份证号码不能为空！", groups = {CustomValidateGroup.Crud.Create.class})
	private String idNumber;
	/** 人脸图片地址 */
	@NotBlank(message = "人脸图片地址不能为空！", groups = {CustomValidateGroup.Crud.Create.class})
	private String imgUrl;


	/* ========以下参数人脸识别专用：imgUrlA与imgBase64A二选一，当URL方式与Base64编码方式共存时，URL方式优先，imgUrlB和imgBase64B同理。 ========*/
	/** 待识别人脸照片url地址 */
	private String imgUrlA;
	/** 待识别人脸照片base64编码 */
	private String imgBase64A;

	/** 人脸库照片url地址 */
	private String imgUrlB;
	/** 人脸库照片base64编码 */
	private String imgBase64B;


	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getIdNumber() {
		return idNumber;
	}

	public void setIdNumber(String idNumber) {
		this.idNumber = idNumber;
	}

	public String getImgUrl() {
		return imgUrl;
	}

	public void setImgUrl(String imgUrl) {
		this.imgUrl = imgUrl;
	}

	public String getImgUrlA() {
		return imgUrlA;
	}

	public void setImgUrlA(String imgUrlA) {
		this.imgUrlA = imgUrlA;
	}

	public String getImgBase64A() {
		return imgBase64A;
	}

	public void setImgBase64A(String imgBase64A) {
		this.imgBase64A = imgBase64A;
	}

	public String getImgUrlB() {
		return imgUrlB;
	}

	public void setImgUrlB(String imgUrlB) {
		this.imgUrlB = imgUrlB;
	}

	public String getImgBase64B() {
		return imgBase64B;
	}

	public void setImgBase64B(String imgBase64B) {
		this.imgBase64B = imgBase64B;
	}
}
