package com.ejianc.business.labor.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 劳务-资格证书
 *
 * @author generator
 */
public class WorkCertificateVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private Integer billState; // 单据状态
    private String createUserName; // 编制人
    private Long operatorId; // 经办人ID
    private String operatorName; // 经办人姓名
    private String updateUserName; // 修改者
    private String remark; // 备注
    private Long workerId; // 人员主表id
    private Long certificateType; // 证书类别
    private String certificateTypeName; // 证书类别名称
    private String certificateName; // 证书名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 结束日期
    private String issue; // 发证机关
    private String certificateCode; // 证书编号
    private Long certificateId;//证书id
    private Long certificateLevel; // 技能等级
    private String certificateLevelName; // 技能等级名称

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @ReferSerialTransfer(referCode = "teamWorkerRef")
    public Long getWorkerId() {
        return workerId;
    }

    @ReferDeserialTransfer
    public void setWorkerId(Long workerId) {
        this.workerId = workerId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCertificateType() {
        return certificateType;
    }

    @ReferDeserialTransfer
    public void setCertificateType(Long certificateType) {
        this.certificateType = certificateType;
    }

    public String getCertificateTypeName() {
        return certificateTypeName;
    }

    public void setCertificateTypeName(String certificateTypeName) {
        this.certificateTypeName = certificateTypeName;
    }

    public String getCertificateName() {
        return certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getIssue() {
        return issue;
    }

    public void setIssue(String issue) {
        this.issue = issue;
    }

    public String getCertificateCode() {
        return certificateCode;
    }

    public void setCertificateCode(String certificateCode) {
        this.certificateCode = certificateCode;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getCertificateId() {
        return certificateId;
    }
    @ReferDeserialTransfer
    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public Long getCertificateLevel() {
        return certificateLevel;
    }

    public void setCertificateLevel(Long certificateLevel) {
        this.certificateLevel = certificateLevel;
    }

    public String getCertificateLevelName() {
        return certificateLevelName;
    }

    public void setCertificateLevelName(String certificateLevelName) {
        this.certificateLevelName = certificateLevelName;
    }
}
