package com.ejianc.business.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.bean.WorkerRegisterEntity;
import com.ejianc.business.labor.enums.TeamSourceTypeEnum;
import com.ejianc.business.labor.service.IWorkerRegisterService;
import com.ejianc.business.labor.vo.OrgTeamVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labor.bean.OrgTeamEntity;
import com.ejianc.business.labor.service.IOrgTeamService;

/**
 * 公司花名册班组
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("orgTeam")
public class OrgTeamController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOrgTeamService service;
    @Autowired
    private IWorkerRegisterService workerRegisterService;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "LABOR_ORG_TEAM";//此处需要根据实际修改

    @RequestMapping(value = "/lazyOrgTeamCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> lazyOrgTeamCategory(Long parentId) {
        //先判断此租户有根组织班组没有
        LambdaQueryWrapper<OrgTeamEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OrgTeamEntity::getTenantId, InvocationInfoProxy.getTenantid());
        int count = service.count(wrapper);
        List<OrgTeamEntity> list = new ArrayList<>();
        if (count == 0) {
            //没有数据需要以租户根组织的作为根班组
            OrgTeamEntity orgTeamEntity = new OrgTeamEntity();
            Long id = IdWorker.getId();
            CommonResponse<OrgVO> orgRes = iOrgApi.findOrgByTenantId(InvocationInfoProxy.getTenantid());
            orgTeamEntity.setId(id);
            orgTeamEntity.setName(orgRes.getData().getName());
            orgTeamEntity.setInnerCode(id.toString());
            orgTeamEntity.setInnerCodeName(orgRes.getData().getName());
            orgTeamEntity.setSourceType(TeamSourceTypeEnum.公司.getStatus());
            orgTeamEntity.setIsLeaf(true);
//            orgTeamEntity.setCode("OT000001");
            service.save(orgTeamEntity);
            list.add(orgTeamEntity);
        } else {
            wrapper.eq(parentId != null, OrgTeamEntity::getParentId, parentId);
            list = service.list(wrapper);
        }
        List<Map> resultMapList = BeanMapper.mapList(list, Map.class);
        return CommonResponse.success(ResultAsTree.createTreeData(resultMapList));
    }


    /**
     * 参照异步（懒加载）树----物资分类树
     * @param condition
     * @param pid
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/lazyOrgTeamTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> lazyOrgTeamTree(@RequestParam(required = false) String condition,
                                                     @RequestParam(required = false) Long pid, @RequestParam(required = false) String searchText) {

        QueryParam param = new QueryParam();
        param.getFuzzyFields().addAll(Arrays.asList("code", "name"));
        param.setSearchText(searchText);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(pid != null){
            param.getParams().put("parentId", new Parameter(QueryParam.EQ, pid));
        }
        Object notContainsIdAndChild = null;
        boolean rootTeamDisabled = false;
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            //修改班组时，参照中的上级节点不能选择自己和自己的子集
            notContainsIdAndChild = _con.get("notContainsIdAndChild");

            //是否禁用根班组选中
            rootTeamDisabled = _con.get("rootTeamDisabled") != null ? Boolean.valueOf(String.valueOf(_con.get("rootTeamDisabled"))) : false;

        }
        List<OrgTeamEntity> orgTeamEntities = service.queryList(param, false);
        List<Map> list = BeanMapper.mapList(orgTeamEntities, Map.class);

        //修改班组时，参照中的上级节点不能选择自己和自己的子集，需要禁用
        if (null != notContainsIdAndChild) {
            for (Map map : list) {
                String innerCode = String.valueOf(map.get("innerCode"));
                if (innerCode.contains(String.valueOf(notContainsIdAndChild))) {
                    map.put("disable", true);
                }
            }
        }
        //是否禁用根班组选中, 项目花名册-引入公司班组，根班组选中需要禁用掉
        if (rootTeamDisabled) {
            for (Map map : list) {
                if (map.get("parentId") == null) {
                    map.put("disableCheckbox", true); // checkBox框禁用
                    //map.put("selectable", false); //文字置灰，不能点击

                }
            }
        }


        return ResultAsTree.createTreeData(list);
    }

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrgTeamVO> saveOrUpdate(@RequestBody OrgTeamVO saveOrUpdateVO) {
        OrgTeamVO vo = service.insertOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrgTeamVO> queryDetail(Long id) {
        OrgTeamEntity entity = service.selectById(id);
        OrgTeamVO vo = BeanMapper.map(entity, OrgTeamVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrgTeamVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OrgTeamVO vo : vos) {
                OrgTeamEntity teamEntity = service.getById(vo.getId());
                if (teamEntity.getParentId() == null) {
                    return CommonResponse.error("删除失败，根班组无法删除！");
                }
                //先查询该班组下是否有子级班组，如果有则无法删除
                LambdaQueryWrapper<OrgTeamEntity> wrapper = new LambdaQueryWrapper();
                wrapper.eq(OrgTeamEntity::getParentId, vo.getId());
                int count = service.count(wrapper);
                if (count > 0) {
                    return CommonResponse.error("删除失败，该班组下有子级，无法删除！");
                }
                // 还需要判断该班组下是否有人员 有则不许删除
                LambdaQueryWrapper<WorkerRegisterEntity> wrapper1 = new LambdaQueryWrapper<>();
                wrapper1.eq(WorkerRegisterEntity::getTeamId, vo.getId());
                int count1 = workerRegisterService.count(wrapper1);
                if (count1 > 0) {
                    return CommonResponse.error("删除失败，该班组下有人员，无法删除！");
                }
            }
        }

        List<Long> delOrgTeamIds = vos.stream().map(OrgTeamVO::getId).collect(Collectors.toList());

        for (OrgTeamVO vo : vos) {
            OrgTeamEntity entity = service.selectById(vo.getId());
            Long parentId = entity.getParentId();
            if (parentId != null) {
                //删除后上级班组没有子级时更改上级班组的isLeaf字段
                LambdaQueryWrapper<OrgTeamEntity> wrapper = new LambdaQueryWrapper();
                wrapper.eq(OrgTeamEntity::getParentId, parentId);
                wrapper.notIn(OrgTeamEntity::getId, delOrgTeamIds);
                int count = service.count(wrapper);
                if (count == 0) {
                    LambdaUpdateWrapper<OrgTeamEntity> updateWrapper = new LambdaUpdateWrapper<>();
                    updateWrapper.set(OrgTeamEntity::getIsLeaf, Boolean.TRUE);
                    updateWrapper.eq(OrgTeamEntity::getId, parentId);
                    service.update(updateWrapper);
                }
            }
        }

        service.removeByIds(delOrgTeamIds);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrgTeamVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OrgTeamEntity> page = service.queryPage(param, false);
        IPage<OrgTeamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrgTeamVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OrgTeamEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("OrgTeam-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refOrgTeamData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrgTeamVO>> refOrgTeamData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                           String condition,
                                                           String searchObject,
                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OrgTeamEntity> page = service.queryPage(param, false);
        IPage<OrgTeamVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrgTeamVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
