package com.ejianc.business.labor.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.Date;

/**
 * 考勤记录
 *
 * @author generator
 */
public interface IAttendanceService extends IBaseService<AttendanceEntity> {

	int totalAttendanceDays(Date enterDate, Date exitDate, Long workerId, Long projectId);

	/**
	 * 按个人统计分页查询
	 *
	 * @param p       分页
	 * @param wrapper 条件构造器
	 *
	 * @param startDate
     * @param endDate
     * @return {@link IPage}<{@link AttendanceEntity}>
	 */
	IPage<AttendanceEntity> queryPageByPerson(Page<AttendanceEntity> p, QueryWrapper<AttendanceEntity> wrapper, String startDate, String endDate);


	Integer queryAttendanceOrgIds(String orgIds);
}
