/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.xiaoshi.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.xiaoshi.bean.XiaoShiEquipEntity;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiEquipService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiEquipApiService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPublicApiService;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiEquipVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="XiaoShiEquipApiService")
public class XiaoShiEquipApiServiceImpl
implements XiaoShiEquipApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IXiaoShiEquipService equipService;
    @Autowired
    private XiaoShiPublicApiService publicApiService;

    @Override
    public List<XiaoShiEquipVO> getEquipPage(Integer pageNum, Integer pageSize) {
        String apiUrl = "/base/device/v1/getList";
        JSONObject queryParam = new JSONObject();
        queryParam.put("pageNum", (Object)pageNum);
        queryParam.put("pageSize", (Object)pageSize);
        JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {
            JSONArray rows = resData.getJSONArray("rows");
            return rows.toJavaList(XiaoShiEquipVO.class);
        }
        return null;
    }

    @Override
    public void synEquip() {
        boolean flag = true;
        Integer pageNum = 1;
        Integer pageSize = 50;
        int synNum = 0;
        List deviceSns = this.equipService.list().stream().map(XiaoShiEquipEntity::getDeviceSn).collect(Collectors.toList());
        Map<String, Long> deviceSnRefMap = this.equipService.list().stream().collect(Collectors.toMap(XiaoShiEquipEntity::getDeviceSn, BaseEntity::getId));
        while (flag) {
            List<XiaoShiEquipVO> equipPage = this.getEquipPage(pageNum, pageSize);
            if (ListUtil.isEmpty(equipPage)) {
                flag = false;
                continue;
            }
            for (XiaoShiEquipVO xiaoShiEquipVO : equipPage) {
                if (!deviceSns.contains(xiaoShiEquipVO.getDeviceSn())) continue;
                xiaoShiEquipVO.setId(deviceSnRefMap.get(xiaoShiEquipVO.getDeviceSn()));
            }
            boolean b = this.equipService.saveOrUpdateBatch(BeanMapper.mapList(equipPage, XiaoShiEquipEntity.class));
            if (b) {
                ++synNum;
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            }
            if (equipPage.size() == pageSize.intValue()) continue;
            flag = false;
        }
        this.logger.info("\u540c\u6b65\u6210\u529f,\u5171\u540c\u6b65" + synNum + "\u6b21,\u6bcf\u6b2150\u6761\u6570\u636e");
    }
}

