package com.ejianc.business.base.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 班组基础库
 * 
 * @author generator
 * 
 */
 @TableName("ejc_labor_base_team")
public class BaseTeamEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="corp_id")
    private Long corpId; // 班组所在企业
    @TableField(value="corp_code")
    private String corpCode; // 班组所在企业统一社会信用代码，如果无统一社会信用代码，则用组织机构代码
    @TableField(value="corp_name")
    private String corpName; // 班组所在企业名称
    @TableField(value="team_name")
    private String teamName; // 班组名称，同一个项目下面不能重复
    @TableField(value="responsible_person_id_card_type")
    private Long responsiblePersonIdCardType; // 责任人证件类型
    @TableField(value="responsible_person_id_card_type_code")
    private String responsiblePersonIdCardTypeCode; // 责任人证件类型编码
    @TableField(value="responsible_person_id_card_type_code_name")
    private String responsiblePersonIdCardTypeCodeName; // 责任人证件类型编码名称
    @TableField(value="responsible_person_name")
    private String responsiblePersonName; // 责任人姓名，班组所在企业负责人
    @TableField(value="responsible_person_phone")
    private String responsiblePersonPhone; // 责任人联系电话
    @TableField(value="responsible_person_id_number")
    private String responsiblePersonIdNumber; // 责任人证件号码。AES
    @TableField(value="entry_time")
    private Date entryTime; // 进场日期
    @TableField(value="exit_time")
    private Date exitTime; // 退场日期
    @TableField(value="entry_attachments")
    private String entryAttachments; // 进场附件，有进场日期时，此字段必填。JSON数组。附件总数不超过5个
    @TableField(value="exit_attachments")
    private String exitAttachments; // 退场附件，有退场日期时，此字段必填。JSON数组。附件总数不超过5个
    @TableField(value = "source_type")
    private String sourceType;//2-队伍 3-班组
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }
    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public String getTeamName() {
        return teamName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }
    public Long getResponsiblePersonIdCardType() {
        return responsiblePersonIdCardType;
    }

    public void setResponsiblePersonIdCardType(Long responsiblePersonIdCardType) {
        this.responsiblePersonIdCardType = responsiblePersonIdCardType;
    }
    public String getResponsiblePersonIdCardTypeCode() {
        return responsiblePersonIdCardTypeCode;
    }

    public void setResponsiblePersonIdCardTypeCode(String responsiblePersonIdCardTypeCode) {
        this.responsiblePersonIdCardTypeCode = responsiblePersonIdCardTypeCode;
    }
    public String getResponsiblePersonIdCardTypeCodeName() {
        return responsiblePersonIdCardTypeCodeName;
    }

    public void setResponsiblePersonIdCardTypeCodeName(String responsiblePersonIdCardTypeCodeName) {
        this.responsiblePersonIdCardTypeCodeName = responsiblePersonIdCardTypeCodeName;
    }
    public String getResponsiblePersonName() {
        return responsiblePersonName;
    }

    public void setResponsiblePersonName(String responsiblePersonName) {
        this.responsiblePersonName = responsiblePersonName;
    }
    public String getResponsiblePersonPhone() {
        return responsiblePersonPhone;
    }

    public void setResponsiblePersonPhone(String responsiblePersonPhone) {
        this.responsiblePersonPhone = responsiblePersonPhone;
    }
    public String getResponsiblePersonIdNumber() {
        return responsiblePersonIdNumber;
    }

    public void setResponsiblePersonIdNumber(String responsiblePersonIdNumber) {
        this.responsiblePersonIdNumber = responsiblePersonIdNumber;
    }
    public Date getEntryTime() {
        return entryTime;
    }

    public void setEntryTime(Date entryTime) {
        this.entryTime = entryTime;
    }
    public Date getExitTime() {
        return exitTime;
    }

    public void setExitTime(Date exitTime) {
        this.exitTime = exitTime;
    }
    public String getEntryAttachments() {
        return entryAttachments;
    }

    public void setEntryAttachments(String entryAttachments) {
        this.entryAttachments = entryAttachments;
    }
    public String getExitAttachments() {
        return exitAttachments;
    }

    public void setExitAttachments(String exitAttachments) {
        this.exitAttachments = exitAttachments;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
}
