package com.ejianc.business.labor.common.dtoMapper;

import com.ejianc.business.labor.bean.AttendanceLogEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.common.annotation.MappingIgnore;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

/**
 * 公司花名册人员映射接口
 *
 * @author baipengyan
 * @version 1.0
 * @since JDK 1.8
 */
@Mapper
public interface WorkMapper {
    WorkMapper INSTANCE = Mappers.getMapper(WorkMapper.class);

    @MappingIgnore
    @Mapping(target = "workerId", source = "id")
    AttendanceLogEntity transformAttendanceLogEntity(WorkerEntity workerEntity);
}
