package com.ejianc.business.other.henger.service;

import com.alibaba.fastjson.JSONObject;

/**
 * 小视科技-api接口，参考文档：
 *      小视科技-AIOT数智服务管理平台API⽂档-V2.5.0.5
 * 
 * @author Jiang
 * 
 */
public interface HengErPublicApiService {
    /**
     * 获取AuthorToken方法
     *
     */
    String getAuthorToken();


    /**
     * 发送请求方法获取token
     *
     * @param ip         设备ip
     * @param apiUrl     接口url
     * @param queryParam 发送参数
     * @return
     */
    JSONObject sendPostRequest(String ip, String apiUrl, JSONObject queryParam);


    /**
     * 将JSON对象的字段首字母转换为小写
     * @param jsonObject
     * @return
     */
    JSONObject lowerCaseJsonObject(JSONObject jsonObject);

}
