package com.ejianc.business.labor.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.labor.bean.UnAttendanceEntity;
import com.ejianc.business.labor.service.IUnAttendanceService;
import com.ejianc.business.labor.vo.UnAttendanceVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 未考勤记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("unAttendance")
public class UnAttendanceController implements Serializable {

    @Autowired
    private IUnAttendanceService service;
    @Resource
    private IOrgApi iOrgApi;

    @Autowired
    private IAttendanceService attendanceService;

    /**
     * 每日记录未考勤人员定时任务
     *
     * @param request 请求
     *
     * @return {@link CommonResponse}<{@link Void}>
     */
    @PostMapping(value = "/unAttendanceTask")
    public CommonResponse<Void> checkTask(HttpServletRequest request) {
        service.unAttendanceTask(request);
        return CommonResponse.success("定时任务，身份证和人脸校验执行成功！");
    }


    /**
     * @Description queryAllAttendanceList 查询所有考勤记录列表
     * @param param
     */
    @RequestMapping(value = "/queryAllAttendanceList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<AttendanceVO>> queryAllAttendanceList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("parentOrgName");
        /** 组织隔离 */
        // 本下组织
        if (param.getParams().containsKey("orgId")) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(Long.parseLong(param.getParams().get("orgId").getValue().toString())).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }

        /** 分页查询 */
        QueryWrapper<AttendanceVO> wrapper = changeToQueryWrapper(param);
        Page<AttendanceVO> p = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage<AttendanceVO> page = attendanceService.queryAllAttendanceRecord(p, wrapper);

        return CommonResponse.success("查询列表数据成功！", page);

    }

}
