package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.labor.mapper.UnAttendanceMapper;
import com.ejianc.business.labor.bean.UnAttendanceEntity;
import com.ejianc.business.labor.service.IUnAttendanceService;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 未考勤记录
 * 
 * @author generator
 * 
 */
@Service("unAttendanceService")
public class UnAttendanceServiceImpl extends BaseServiceImpl<UnAttendanceMapper, UnAttendanceEntity> implements IUnAttendanceService{


    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttendanceService attendanceService;


    @Override
    public void unAttendanceTask(HttpServletRequest request) {
        logger.info("定时任务，未考勤人员记录，start！");

        QueryWrapper<AttendanceVO> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("flag","否");
        List<AttendanceVO> attendanceList = attendanceService.queryDailyAttendanceList(queryWrapper);

        if(ListUtil.isNotEmpty(attendanceList)){
            for (AttendanceVO attendanceVO : attendanceList) {
                attendanceVO.setPunchCardDate(new Date());
            }
            this.saveBatch(BeanMapper.mapList(attendanceList,UnAttendanceEntity.class));
        }


        logger.info("定时任务，未考勤人员记录，end！");
    }
}
