/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.desktop.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.desktop.vo.AttendancePerLineVO;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.service.IUnAttendanceService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"deskTop"})
public class DeskTopController {
    @Resource
    private IOrgApi iOrgApi;
    @Autowired
    private IUnAttendanceService unAttendanceService;
    @Autowired
    private IAttendanceService attendanceService;
    @Autowired
    private IWorkRecordService workRecordService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/queryAttendancePerLine"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<AttendancePerLineVO>> queryAttendancePerLine(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("parentOrgName");
        ArrayList commonOrgIds = new ArrayList();
        List orgVOList = null;
        orgVOList = param.getParams().containsKey("orgId") ? (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        param.getParams().put("dr", new Parameter("in", (Object)0));
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<AttendancePerLineVO> vos = this.attendanceService.queryAttendancePerLine((QueryWrapper<AttendanceVO>)wrapper);
        if (ListUtil.isNotEmpty(vos)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"enter_exit_state", (Object)1);
            queryWrapper.in((Object)"org_id", commonOrgIds);
            List list = this.workRecordService.list((Wrapper)queryWrapper);
            for (AttendancePerLineVO vo : vos) {
                if (DateUtil.isSameDay((Date)vo.getPunchCardDate(), (Date)new Date())) {
                    vo.setTotalNum(Integer.valueOf(list.size()));
                }
                BigDecimal attendancePer = BigDecimal.ZERO;
                if (vo.getAttendanceNum() == null || vo.getTotalNum() == null) continue;
                BigDecimal attendanceB = new BigDecimal(vo.getAttendanceNum());
                BigDecimal totalB = new BigDecimal(vo.getTotalNum());
                attendancePer = totalB.compareTo(attendancePer) == 0 ? BigDecimal.ONE : attendanceB.divide(totalB, 4, 4);
                vo.setAttendancePer(attendancePer);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", vos);
    }

    @RequestMapping(value={"/queryUserTypeByGroupCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryUserTypeByGroupCode(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        ArrayList commonOrgIds = new ArrayList();
        List orgVOList = null;
        orgVOList = param.getParams().containsKey("orgId") ? (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("orgId")).getValue().toString()))), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        orgVOList.stream().forEach(org -> commonOrgIds.add(org.getId()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        param.getParams().put("dr", new Parameter("in", (Object)0));
        param.getParams().put("enterExitState", new Parameter("eq", (Object)1));
        ArrayList<String> groupCodeList = new ArrayList<String>();
        groupCodeList.add("person_type");
        groupCodeList.add("inner_type");
        groupCodeList.add("culture_level_type");
        groupCodeList.add("work_role");
        groupCodeList.add("work_type");
        String groupCode = null;
        String groupName = null;
        if (param.getParams().get("groupCode") != null && param.getParams().get("groupName") != null) {
            groupCode = ((Parameter)param.getParams().get("groupCode")).getValue().toString();
            groupName = ((Parameter)param.getParams().get("groupName")).getValue().toString();
            param.getParams().remove("groupCode");
            param.getParams().remove("groupName");
            if (!groupCodeList.contains(groupCode)) {
                this.logger.info("\u4f20\u9012\u5206\u7ec4\u53c2\u6570\u5f02\u5e38");
                return CommonResponse.error((String)"\u7cfb\u7edf\u9519\u8bef\uff01");
            }
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy((Object[])new String[]{groupCode});
        wrapper.select(new String[]{groupCode + " as type," + groupName + " as typeName,count(*) as value"});
        List maps = this.workRecordService.listMaps((Wrapper)wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)maps);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

