/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.bean.WorkerExitDetailEntity;
import com.ejianc.business.labor.bean.WorkerExitEntity;
import com.ejianc.business.labor.service.ISalaryService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.service.IWorkerExitService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.utils.EJCDateUtil;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.enums.EquipStatusEnum;
import com.ejianc.business.other.henger.enums.ServiceTypeEnum;
import com.ejianc.business.other.henger.service.HengErPersonApiService;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.service.IHengErTaskService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="workerExit")
public class WorkerExitBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IWorkerExitService service;
    @Autowired
    private ISalaryService salaryService;
    @Resource
    private IWorkerEnterService workerEnterService;
    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private IHengErTaskService hengErTaskService;
    @Autowired
    private HengErPersonApiService hengErPersonApiService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        WorkerExitEntity workerExitEntity = (WorkerExitEntity)((Object)this.service.selectById(billId));
        List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
        if (CollectionUtils.isNotEmpty(workerExitDetailList)) {
            for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
                WorkerEnterEntity workerEnterEntity;
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(WorkRecordEntity::getProjectId, (Object)workerExitEntity.getProjectId());
                updateWrapper.eq(WorkRecordEntity::getWorkerId, (Object)workerExitDetailEntity.getWorkerId());
                updateWrapper.eq(WorkRecordEntity::getLastFlag, (Object)1);
                updateWrapper.set(WorkRecordEntity::getEnterExitState, (Object)0);
                updateWrapper.set(WorkRecordEntity::getExitDate, (Object)workerExitDetailEntity.getExitDate());
                this.workRecordService.update((Wrapper)updateWrapper);
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WorkRecordEntity::getProjectId, (Object)workerExitEntity.getProjectId())).eq(WorkRecordEntity::getWorkerId, (Object)workerExitDetailEntity.getWorkerId())).eq(WorkRecordEntity::getLastFlag, (Object)1);
                WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)wrapper));
                if (workRecordEntity != null && workRecordEntity.getSourceFlag() == 1 && workRecordEntity.getSourceId() != null && (workerEnterEntity = (WorkerEnterEntity)((Object)this.workerEnterService.selectById(workRecordEntity.getSourceId()))) != null) {
                    workerEnterEntity.setExitDate(workerExitDetailEntity.getExitDate());
                    this.workerEnterService.updateById((Object)workerEnterEntity);
                }
                LambdaUpdateWrapper workerWrapper = new LambdaUpdateWrapper();
                workerWrapper.eq(BaseEntity::getId, (Object)workerExitDetailEntity.getWorkerId());
                workerWrapper.set(WorkerEntity::getWorkState, (Object)0);
                this.workerService.update((Wrapper)workerWrapper);
                List hengErEquipEntities = this.hengErEquipService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(HengErEquipEntity::getProjectId, (Object)workerExitEntity.getProjectId())).ne(HengErEquipEntity::getEquipStatus, (Object)EquipStatusEnum.\u672a\u540c\u6b65)).in(HengErEquipEntity::getBillState, Arrays.asList(1, 3)));
                if (!ListUtil.isNotEmpty((List)hengErEquipEntities)) continue;
                for (HengErEquipEntity hengErEquipEntity : hengErEquipEntities) {
                    JSONObject serviceRequest = this.hengErPersonApiService.getDelCom(workerExitDetailEntity, hengErEquipEntity.getEquipSn());
                    this.hengErTaskService.addTaskByType(hengErEquipEntity.getEquipSn(), workerExitDetailEntity.getId(), ServiceTypeEnum.\u5355\u4e2a\u540d\u5355\u6dfb\u52a0.getStatus(), serviceRequest.toJSONString());
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        WorkerExitEntity workerExitEntity = (WorkerExitEntity)((Object)this.service.selectById(billId));
        List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
        if (CollectionUtils.isNotEmpty(workerExitDetailList)) {
            for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
                QueryWrapper objectQueryWrapper = new QueryWrapper();
                objectQueryWrapper.eq((Object)"project_id", (Object)workerExitEntity.getProjectId());
                objectQueryWrapper.eq((Object)"worker_id", (Object)workerExitDetailEntity.getWorkerId());
                objectQueryWrapper.eq((Object)"enter_exit_state", (Object)1);
                List list = this.workRecordService.list((Wrapper)objectQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    String err = "\u59d3\u540d:" + workerExitDetailEntity.getWorkerName() + ",\u5df2\u7ecf\u8fdb\u573a,\u4e0d\u652f\u6301\u5f03\u5ba1";
                    return CommonResponse.error((String)err);
                }
                String exitDate = EJCDateUtil.format(workerExitDetailEntity.getExitDate(), "yyyy-MM");
                Integer con = this.salaryService.haveSalaryFlag(workerExitDetailEntity.getWorkerId(), exitDate);
                if (con <= 1) continue;
                String err = "\u59d3\u540d:" + workerExitDetailEntity.getWorkerName() + ",\u5df2\u7ecf\u6709\u5de5\u8d44\u5355,\u4e0d\u652f\u6301\u5f03\u5ba1";
                return CommonResponse.error((String)err);
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        WorkerExitEntity workerExitEntity = (WorkerExitEntity)((Object)this.service.selectById(billId));
        List<WorkerExitDetailEntity> workerExitDetailList = workerExitEntity.getWorkerExitDetailList();
        if (CollectionUtils.isNotEmpty(workerExitDetailList)) {
            for (WorkerExitDetailEntity workerExitDetailEntity : workerExitDetailList) {
                WorkerEnterEntity workerEnterEntity;
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(WorkRecordEntity::getProjectId, (Object)workerExitEntity.getProjectId());
                updateWrapper.eq(WorkRecordEntity::getWorkerId, (Object)workerExitDetailEntity.getWorkerId());
                updateWrapper.eq(WorkRecordEntity::getLastFlag, (Object)1);
                updateWrapper.set(WorkRecordEntity::getEnterExitState, (Object)1);
                updateWrapper.set(WorkRecordEntity::getExitDate, null);
                this.workRecordService.update((Wrapper)updateWrapper);
                LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WorkRecordEntity::getProjectId, (Object)workerExitEntity.getProjectId())).eq(WorkRecordEntity::getWorkerId, (Object)workerExitDetailEntity.getWorkerId())).eq(WorkRecordEntity::getLastFlag, (Object)1);
                WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.getOne((Wrapper)wrapper));
                if (workRecordEntity != null && workRecordEntity.getSourceFlag() == 1 && workRecordEntity.getSourceId() != null && (workerEnterEntity = (WorkerEnterEntity)((Object)this.workerEnterService.selectById(workRecordEntity.getSourceId()))) != null) {
                    workerEnterEntity.setExitDate(null);
                    this.workerEnterService.updateById((Object)workerEnterEntity);
                }
                LambdaUpdateWrapper workerWrapper = new LambdaUpdateWrapper();
                workerWrapper.eq(BaseEntity::getId, (Object)workerExitDetailEntity.getWorkerId());
                workerWrapper.set(WorkerEntity::getWorkState, (Object)1);
                this.workerService.update((Wrapper)workerWrapper);
            }
        }
        return CommonResponse.success();
    }
}

