package com.ejianc.business.other.yufan.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IPorjectService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.service.IHengErEquipService;

import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonVO;
import com.ejianc.business.other.yufan.service.YuFanPersonApiService;
import com.ejianc.business.other.yufan.service.YuFanPublicApiService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import feign.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;


@Service("YuFanPersonApiService")
public class YuFanPersonApiServiceImpl implements YuFanPersonApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private YuFanPublicApiService publicApiService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPorjectService projectService;
    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private IWorkRecordService workRecordService;


    @Override
    public String addOrUpdate(WorkRecordVO vo) {

        String admitGuid = vo.getSn();
        //如果已经同步过，有sn了不再新增
        if(StringUtils.isNotEmpty(vo.getSn())){
            /**
             * 人员基本信息
             */

            JSONObject queryParam = new JSONObject();

            queryParam.put("name",vo.getName());
            queryParam.put("phone",vo.getPhone());
            queryParam.put("idCardNo",vo.getIdCardNo());
            queryParam.put("admitGuid",vo.getSn());

            /**
             * 发送请求
             */
            String apiUrl = "/v2/admit/update";

            JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
        } else {
            /**
             * 人员基本信息
             */
            JSONObject queryParam = new JSONObject();
            queryParam.put("name",vo.getName());
            queryParam.put("phone",vo.getPhone());
            queryParam.put("idCardNo",vo.getIdCardNo());
            /**
             * 发送请求
             */
            String apiUrl = "/v2/admit/create";

            JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
            admitGuid = resData.getString("admitGuid");
            workRecordService.update(Wrappers.<WorkRecordEntity>lambdaUpdate()
                    .set(WorkRecordEntity::getSn,admitGuid)
                    .set(WorkRecordEntity::getSnDate,new Date())
                    .eq(WorkRecordEntity::getId,vo.getId())
            );
        }



        //人像注册
        Map<Long, AttachmentVO> fileIdRef = new HashMap<>();//附件sourceId-fileId
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.queryListBySourceId(vo.getId(),null,null,null);
        if (listCommonResponse.isSuccess()) {
            List<AttachmentVO> fileData = listCommonResponse.getData();
            if(ListUtil.isEmpty(fileData)){
                logger.info("无图片信息！");
            }
            fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face"))
                    .collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        } else{
            throw new BusinessException("访问文件服务异常!");
        }
        /**
         * 1.1获取图片唯一标识
         */
        AttachmentVO attachmentVO = fileIdRef.get(vo.getId());
        String fileName = attachmentVO.getFileName();
        //图片类型：1-jpg，2-png
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);

        this.pushPersonPic(fileIdRef.get(vo.getId()).getId(), "jpg".equals(suffix) ? 1 : 2,admitGuid);
        PorjectEntity entity = projectService.selectById(vo.getProjectId());

        List<HengErEquipEntity> list = hengErEquipService.list(Wrappers.<HengErEquipEntity>lambdaQuery()
                .eq(HengErEquipEntity::getProjectId, entity.getId())
                .in(HengErEquipEntity::getBillState, Arrays.asList(1, 3))
        );
        for (HengErEquipEntity hengErEquipEntity : list) {
            this.bindDeviceAndPerson(admitGuid,hengErEquipEntity.getEquipSn());
            this.bindDeviceAndPerson(admitGuid,hengErEquipEntity.getEquipSn());
        }

        return admitGuid;
    }
    @Override
    public void deletePerson(String admitGuids) {

        String apiUrl = "/v2/admit/delete";
        JSONObject queryParam = new JSONObject();
        queryParam.put("admitGuids",admitGuids);

        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
    }


    //绑定设备
    @Override
    public boolean bindDeviceAndPerson(String admitGuid,String deviceNo){
        String apiUrl = "/v2/auth/device";
        JSONObject queryParam = new JSONObject();
        queryParam.put("admitGuids",admitGuid);
        queryParam.put("deviceNo",deviceNo);

        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);

        return true;
    }
    //撤销绑定设备
    @Override
    public boolean revokeDeviceAndPerson(String admitGuid,String deviceNo){
        String apiUrl = "/v2/auth/device/revoke";
        JSONObject queryParam = new JSONObject();
        queryParam.put("admitGuids",admitGuid);
        queryParam.put("deviceNo",deviceNo);

        JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);

        return true;
    }

    private boolean pushPersonPic(Long fileId, Integer imageType,String admitGuid) {

        /**
         * 获取服务器中图片
         */
        Response response = attachmentApi.downloadFileById(fileId);
        try {
            /**
             * 转化为base64编码
             */
            InputStream inputStream = response.body().asInputStream();
            byte[] bytes = IOUtils.toByteArray(inputStream);
            String image = Base64.getEncoder().encodeToString(bytes);

            /**
             * 发送图片获取图片唯一标识faceToken
             */
            String apiUrl = "/v2/face/register";
            JSONObject queryParam = new JSONObject();
            queryParam.put("admitGuid",admitGuid);
            queryParam.put("base64",image);
            JSONObject resData = publicApiService.sendPostRequest(apiUrl, queryParam);
            return true;

        } catch (IOException e) {
            e.printStackTrace();
        }

        return false;
    }
}
