package com.ejianc.business.other.dangong.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.dangong.service.DanGongPersonApiService;
import com.ejianc.business.other.dangong.vo.DanGongPersonVO;
import com.ejianc.business.other.dangong.vo.DanGongPublicResultVO;
import com.ejianc.business.other.dangong.vo.DanGongResultUtils;
import com.ejianc.business.other.henger.enums.ServiceTypeEnum;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.xml.transform.Result;
import java.io.Serializable;
import java.util.List;

/**
 * @Author: jiang
 * @Date: 2025/8/7 17:57
 **/
@Controller
@RequestMapping("danGongPerson")
public class DanGongPersonController implements Serializable {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private DanGongPersonApiService danGongPersonApiService;


    /**
     * init初始化配置请求
     * @return
     */
    @RequestMapping(value = "/init", method = RequestMethod.GET)
    @ResponseBody
    public DanGongPublicResultVO init(String deviceId,String productId,String mac,String porttype) {
        logger.info("初始化配置");
        return DanGongResultUtils.success("init",null);
    }


    /**
     * 下载白名单
     * @return
     */
    @RequestMapping(value = "/workers", method = RequestMethod.GET)
    @ResponseBody
    public DanGongPublicResultVO workers(String deviceId,String productId,String update) {
        logger.info("获取人员信息开始");
        List<DanGongPersonVO> workerList = danGongPersonApiService.getWorkerList(deviceId, productId, update);
        return DanGongResultUtils.success("workers",workerList);
    }


}
