/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.xiaoshi.service.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.PorjectEntity;
import com.ejianc.business.labor.service.IPorjectService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkRecordVO;
import com.ejianc.business.other.xiaoshi.bean.XiaoShiPersonEntity;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiPersonService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPersonApiService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPublicApiService;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonPicVO;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiPersonVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="XiaoShiPersonApiService")
public class XiaoShiPersonApiServiceImpl
implements XiaoShiPersonApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IXiaoShiPersonService personService;
    @Autowired
    private XiaoShiPublicApiService publicApiService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IWorkRecordService recordService;
    @Autowired
    private IPorjectService projectService;

    @Override
    public List<XiaoShiPersonVO> getPage(Integer pageNum, Integer pageSize) {
        String apiUrl = "/base/person/v2/queryPersonByOrgPageList";
        JSONObject queryParam = new JSONObject();
        queryParam.put("pageNum", (Object)pageNum);
        queryParam.put("pageSize", (Object)pageSize);
        JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
        if (resData != null) {
            JSONArray rows = resData.getJSONArray("rows");
            return rows.toJavaList(XiaoShiPersonVO.class);
        }
        return null;
    }

    @Override
    public String add(WorkRecordVO vo) {
        List fileData;
        XiaoShiPersonVO xiaoShiPersonVO = new XiaoShiPersonVO();
        Map<Object, Object> fileIdRef = new HashMap();
        CommonResponse listCommonResponse = this.attachmentApi.queryListBySourceId(vo.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            fileData = (List)listCommonResponse.getData();
            if (ListUtil.isEmpty((List)fileData)) {
                this.logger.info("\u65e0\u56fe\u7247\u4fe1\u606f\uff01");
            }
        } else {
            throw new BusinessException("\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5f02\u5e38!");
        }
        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        AttachmentVO attachmentVO = (AttachmentVO)fileIdRef.get(vo.getId());
        String fileName = attachmentVO.getFileName();
        String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        XiaoShiPersonPicVO xiaoShiPersonPicVO = this.pushPersonPic(((AttachmentVO)fileIdRef.get(vo.getId())).getId(), "jpg".equals(suffix) ? 1 : 2);
        ArrayList<XiaoShiPersonPicVO> personPicVOS = new ArrayList<XiaoShiPersonPicVO>();
        personPicVOS.add(xiaoShiPersonPicVO);
        PorjectEntity projectEntity = (PorjectEntity)((Object)this.projectService.selectById(vo.getProjectId()));
        ArrayList<String> groupIds = new ArrayList<String>();
        groupIds.add(projectEntity.getGroupId());
        xiaoShiPersonVO.setGroupIds(groupIds);
        xiaoShiPersonVO.setPersonName(vo.getName());
        if (vo.getSex() != null) {
            xiaoShiPersonVO.setSex(Integer.valueOf(vo.getSex() == 1 ? vo.getSex() : 0));
        }
        xiaoShiPersonVO.setCardNo(vo.getIdCardNo());
        xiaoShiPersonVO.setPhone(vo.getPhone());
        xiaoShiPersonVO.setPersonCode(vo.getId().toString());
        xiaoShiPersonVO.setFaceTokens(personPicVOS);
        String apiUrl = "/base/person/v2/add";
        String personJSONString = JSONObject.toJSONString((Object)xiaoShiPersonVO);
        JSONObject queryParam = JSONObject.parseObject((String)personJSONString);
        JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
        return resData.getString("personId");
    }

    @Override
    public void delete(List<Long> workIds) {
        if (ListUtil.isEmpty(workIds)) {
            throw new BusinessException("\u5220\u9664\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        List personEntities = this.personService.list((Wrapper)Wrappers.lambdaQuery().in(XiaoShiPersonEntity::getPersonCode, workIds));
        List personIds = personEntities.stream().map(XiaoShiPersonEntity::getPersonId).collect(Collectors.toList());
        String apiUrl = "/base/person/v1/batchDelete";
        JSONObject queryParam = new JSONObject();
        JSONArray jsonArray = JSON.parseArray((String)JSONObject.toJSONString(personIds));
        queryParam.put("personIds", (Object)jsonArray);
        JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
        this.personService.removeByIds(workIds);
    }

    @Override
    public void update(String personId) {
    }

    private XiaoShiPersonPicVO pushPersonPic(Long fileId, Integer imageType) {
        Response response = this.attachmentApi.downloadFileById(fileId);
        try {
            InputStream inputStream = response.body().asInputStream();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            String image = Base64.getEncoder().encodeToString(bytes);
            String apiUrl = "/base/person/v1/imageUpload";
            JSONObject queryParam = new JSONObject();
            queryParam.put("image", (Object)image);
            queryParam.put("imageType", (Object)imageType);
            JSONObject resData = this.publicApiService.sendPostRequest(apiUrl, queryParam);
            return (XiaoShiPersonPicVO)resData.toJavaObject(XiaoShiPersonPicVO.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void synPerson() {
        boolean flag = true;
        Integer pageNum = 1;
        Integer pageSize = 50;
        int synNum = 0;
        List sourceIds = this.personService.list().stream().map(XiaoShiPersonEntity::getPersonId).collect(Collectors.toList());
        Map<String, Long> refMap = this.personService.list().stream().collect(Collectors.toMap(XiaoShiPersonEntity::getPersonId, BaseEntity::getId));
        while (flag) {
            List<XiaoShiPersonVO> personPage = this.getPage(pageNum, pageSize);
            if (ListUtil.isEmpty(personPage)) {
                flag = false;
                continue;
            }
            for (XiaoShiPersonVO xiaoShiPersonVO : personPage) {
                if (!sourceIds.contains(xiaoShiPersonVO.getPersonId())) continue;
                xiaoShiPersonVO.setId(refMap.get(xiaoShiPersonVO.getPersonId()));
            }
            boolean b = this.personService.saveOrUpdateBatch(BeanMapper.mapList(personPage, XiaoShiPersonEntity.class));
            if (b) {
                ++synNum;
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            }
            if (personPage.size() == pageSize.intValue()) continue;
            flag = false;
        }
        this.logger.info("\u540c\u6b65\u6210\u529f,\u5171\u540c\u6b65" + synNum + "\u6b21,\u6bcf\u6b2150\u6761\u6570\u636e");
    }
}

