package com.ejianc.business.other.xiaoshi.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.xiaoshi.vo.XiaoShiEquipVO;

import java.util.List;

/**
 * 小视科技-api接口，参考文档：
 *      小视科技-AIOT数智服务管理平台API⽂档-V2.5.0.5
 * 
 * @author Jiang
 * 
 */
public interface XiaoShiPublicApiService {
    /**
     * 获取AuthorToken方法
     *  JSON:
     *      appKey:     appKey
     *      timestamp:  毫秒时间戳
     *      signature:  签名
     *      token:      token
     *
     */
    JSONObject getAuthorToken();


    /**
     * 业务请求api（header不放入token）
     * @param queryUrl
     * @param queryParam
     * @return
     */
    JSONObject sendPostRequestNoAuth(String queryUrl, JSONObject queryParam);

    /**
     * 业务请求api
     * @param queryUrl
     * @param queryParam
     * @return
     */
    JSONObject sendPostRequest(String queryUrl, JSONObject queryParam);
}
