package com.ejianc.business.other.henger.service;


import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.labor.bean.WorkerExitDetailEntity;
import com.ejianc.business.labor.vo.WorkRecordVO;

/**
 * 人员api
 *
 * @author Jiang
 */
public interface HengErPersonApiService {

    /**
     * 局域网测试类
     * 添加人员信息
     */
    void add(WorkRecordVO vo);

    /**
     * 广域网：
     * 获取添加人员指令
     */
    JSONObject getAddCom(WorkRecordVO vo, String equipSn);

    /**
     * 广域网：
     * 获取删除人员指令
     *
     * @param vo
     * @param equipSn
     * @return
     */
    JSONObject getDelCom(WorkerExitDetailEntity vo, String equipSn);

    /**
     * 广域网：
     * 批量查询设备中名单指令
     *
     * @param equipSn 设备序列号
     * @param beginNO 查询列表的起始位置,即从第几个人开始
     * @return
     */
    JSONObject getSearchPersonListCom(String equipSn,Integer beginNO);

    /**
     * 广域网：
     * 查询设备中单个名单指令
     *
     * @param equipSn
     * @param workerId
     * @return
     */
    JSONObject getSearchPersonCom(String equipSn, Long workerId);
}
