package com.ejianc.business.labor.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.labor.bean.TrainRecordEntity;
/**
 * 劳务-培训考试
 * 
 * @author generator
 * 
 */
 @TableName("ejc_labor_train")
public class TrainEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="train_type")
    private Long trainType; // 培训类型
    @TableField(value="train_type_name")
    private String trainTypeName; // 培训类型名称
    @TableField(value="train_topic_name")
    private String trainTopicName; // 培训主题
    @TableField(value="service_date")
    private Date serviceDate; // 培训日期
    @TableField(value="train_address")
    private String trainAddress; // 培训地址
    @TableField(value="duty_person")
    private Long dutyPerson; // 组织者
    @TableField(value="duty_person_name")
    private String dutyPersonName; // 组织者名称
    @TableField(value="finish_flag")
    private String finishFlag; // 完成状态
    @TableField(value="train_num")
    private Integer trainNum; // 参加人数
    @TableField(value="pass_num")
    private Integer passNum; // 合格人数
    @TableField(value="pass_rate")
    private BigDecimal passRate; // 合格率
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="trainRecordService",pidName = "trainId")
    private List<TrainRecordEntity> trainRecordList = new ArrayList<>(); // 劳务-培训考试参加记录
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Long getTrainType() {
        return trainType;
    }

    public void setTrainType(Long trainType) {
        this.trainType = trainType;
    }
    public String getTrainTypeName() {
        return trainTypeName;
    }

    public void setTrainTypeName(String trainTypeName) {
        this.trainTypeName = trainTypeName;
    }
    public String getTrainTopicName() {
        return trainTopicName;
    }

    public void setTrainTopicName(String trainTopicName) {
        this.trainTopicName = trainTopicName;
    }
    public Date getServiceDate() {
        return serviceDate;
    }

    public void setServiceDate(Date serviceDate) {
        this.serviceDate = serviceDate;
    }
    public String getTrainAddress() {
        return trainAddress;
    }

    public void setTrainAddress(String trainAddress) {
        this.trainAddress = trainAddress;
    }
    public Long getDutyPerson() {
        return dutyPerson;
    }

    public void setDutyPerson(Long dutyPerson) {
        this.dutyPerson = dutyPerson;
    }
    public String getDutyPersonName() {
        return dutyPersonName;
    }

    public void setDutyPersonName(String dutyPersonName) {
        this.dutyPersonName = dutyPersonName;
    }
    public String getFinishFlag() {
        return finishFlag;
    }

    public void setFinishFlag(String finishFlag) {
        this.finishFlag = finishFlag;
    }
    public Integer getTrainNum() {
        return trainNum;
    }

    public void setTrainNum(Integer trainNum) {
        this.trainNum = trainNum;
    }
    public Integer getPassNum() {
        return passNum;
    }

    public void setPassNum(Integer passNum) {
        this.passNum = passNum;
    }
    public BigDecimal getPassRate() {
        return passRate;
    }

    public void setPassRate(BigDecimal passRate) {
        this.passRate = passRate;
    }
    

    public List<TrainRecordEntity> getTrainRecordList() {
        return trainRecordList;
    }

    public void setTrainRecordList(List<TrainRecordEntity> trainRecordList) {
        this.trainRecordList = trainRecordList;
    }
}
