package com.ejianc.business.other.henger.service.api;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.other.henger.service.HengErPublicApiService;
import com.ejianc.business.other.xiaoshi.bean.XiaoShiLogEntity;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiEquipService;
import com.ejianc.business.other.xiaoshi.service.IXiaoShiLogService;
import com.ejianc.business.other.xiaoshi.service.XiaoShiPublicApiService;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import jodd.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

/**
 * 恒尔接口公用api
 *
 * @author generator
 */

@Service("HengErPublicApiService")
public class HengErPublicApiServiceImpl implements HengErPublicApiService {


    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IXiaoShiEquipService equipService;

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private CacheManager cacheManager;

    @Autowired
    private IXiaoShiLogService xiaoShiLogService;

    private static String User = "admin";
    private static String Pwd = "admin";
    private static String base = "http://";


    @Override
    public String getAuthorToken() {
        byte[] key = (User + ":" + Pwd).getBytes();
        return Base64.encodeToString(key);

    }


    @Override
    public JSONObject sendPostRequest(String ip, String apiUrl, JSONObject queryParam) {
        try {
            logger.info("设备ip为" + apiUrl);
            logger.info("业务api为" + apiUrl);
            logger.info("参数为" + queryParam.toJSONString());

            URL url = new URL(base + ip + "/action/" + apiUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            String authorToken = getAuthorToken();
            /**
             * header中添加必要的token信息
             */
            connection.setRequestProperty("Authorization", "Basic " + authorToken);
            // 在Header中添加参数
//            connection.setRequestProperty("sign", sign);
            connection.setDoOutput(true);
            // 将JSON字符串作为请求体发送
            OutputStream outputStream = connection.getOutputStream();
            outputStream.write(queryParam.toString().getBytes());

            outputStream.flush();
            // 发送请求并获取响应
            int responseCode = connection.getResponseCode();

            // 检查响应是否成功
            if (responseCode == HttpURLConnection.HTTP_OK) {
                // 读取响应数据
                InputStream inputStream = connection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                logger.info("调用接口查询结果为{}", response.toString());


//                /**
//                 * 每次请求保存日志
//                 */
//                XiaoShiLogEntity xiaoShiLogEntity = new XiaoShiLogEntity();
//                xiaoShiLogEntity.setInputParams(queryParam.toString());
//                xiaoShiLogEntity.setInterfaceName(queryUrl);
//                xiaoShiLogEntity.setResData(response.toString());
//                JSONObject baseResJSON = JSONObject.parseObject(response.toString());
//                if (baseResJSON != null) {
//                    String resCode = baseResJSON.getString("resCode");
//                    String resMsg = baseResJSON.getString("resMsg");
//                    xiaoShiLogEntity.setResCode(resCode);
//                    xiaoShiLogEntity.setResMsg(resMsg);
//                }
//                xiaoShiLogService.saveOrUpdate(xiaoShiLogEntity);
                JSONObject baseResJSON = JSONObject.parseObject(response.toString());
                return handelResJSON(baseResJSON, url.toString());
            }
            logger.info("服务器未响应" + responseCode);
            throw new BusinessException(responseCode);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    /**
     * 处理返回结果
     *
     * @param resJSON
     * @return
     */
    private JSONObject handelResJSON(JSONObject resJSON, String queryUrl) {
        logger.info("处理查询结果");
        if (resJSON == null) {
            throw new BusinessException("网络异常，无法建立连接，请稍后再试！");
        }


        String operator = resJSON.getString("operator");
        String code = resJSON.getString("code");
        if (!code.equals("200")) {
            logger.info("请求错误！" + code);
            throw new BusinessException("服务器返回" + code);
        }
        JSONObject info = resJSON.getJSONObject("info");

        return info;
    }

    @Override
    public JSONObject lowerCaseJsonObject(JSONObject jsonObject) {
        JSONObject lowerCaseJsonObject = new JSONObject();
        for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
            String lowerCaseKey = entry.getKey().substring(0, 1).toLowerCase() + entry.getKey().substring(1);
            lowerCaseJsonObject.put(lowerCaseKey, entry.getValue());
        }
        return lowerCaseJsonObject;
    }
}
