package com.ejianc.business.labor.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 企业基本信息
 * 
 * @author generator
 * 
 */
 @TableName("ejc_labor_enterprise")
public class EnterpriseEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="corp_code")
    private String corpCode; // 企业统一社会信用代码，如果无统一社会信用代码，则用组织机构代码
    @TableField(value="corp_name")
    private String corpName; // 企业名称
    @TableField(value="corp_type_id")
    private String corpTypeId; // 单位性质id
    @TableField(value="corp_type_code")
    private String corpTypeCode; // 单位性质编码
    @TableField(value="corp_type_name")
    private String corpTypeName; // 单位性质。参考企业登记注册类型字典表
    @TableField(value="license_num")
    private String licenseNum; // 工商营业执照注册号
    @TableField(value="area_id")
    private String areaId; // 企业注册地区id
    @TableField(value="area_name")
    private String areaName; // 企业注册地区名称
    @TableField(value="area_code")
    private String areaCode; // 企业注册地区编码。参考行政区划字典表
    @TableField(value="address")
    private String address; // 企业营业地址
    @TableField(value="zip_code")
    private String zipCode; // 邮政编码
    @TableField(value="legal_man_id")
    private Long legalManId; // 法定代表人id
    @TableField(value="legal_man_name")
    private String legalManName; // 法定代表人姓名
    @TableField(value="legal_man_duty")
    private String legalManDuty; // 法定代表人职务
    @TableField(value="lega_man_pro_title")
    private String legaManProTitle; // 法定代表人职称
    @TableField(value="legal_man_id_card_type_id")
    private String legalManIdCardTypeId; // 法定代表人证件类型id
    @TableField(value="legal_man_id_card_type_code")
    private String legalManIdCardTypeCode; // 法定代表人证件类型编码
    @TableField(value="legal_man_id_card_type_name")
    private String legalManIdCardTypeName; // 法定代表人证件类型。参考人员证件类型字典表
    @TableField(value="legal_man_id_card_number")
    private String legalManIdCardNumber; // 法定代表人证件号码。AES
    @TableField(value="reg_capital")
    private BigDecimal regCapital; // 注册资本（万元）
    @TableField(value="fact_reg_capital")
    private BigDecimal factRegCapital; // 实收资本(万元)
    @TableField(value="capital_currency_type_id")
    private String capitalCurrencyTypeId; // 注册资本币种id
    @TableField(value="capital_currency_type_code")
    private String capitalCurrencyTypeCode; // 注册资本币种编码
    @TableField(value="capital_currency_type_name")
    private String capitalCurrencyTypeName; // 注册资本币种。参考币种字典表
    @TableField(value="register_date")
    private Date registerDate; // 注册日期，格式yyyy-MM-dd
    @TableField(value="establish_date")
    private Date establishDate; // 成立日期，格式yyyy-MM-dd
    @TableField(value="office_phone")
    private String officePhone; // 办公电话
    @TableField(value="fax_number")
    private String faxNumber; // 传真号码
    @TableField(value="link_man")
    private String linkMan; // 联系人姓名
    @TableField(value="link_phone")
    private String linkPhone; // 联系人办公电话
    @TableField(value="email")
    private String email; // 企业联系邮箱
    @TableField(value="website")
    private String website; // 企业网址
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="operator_id")
    private Long operatorId; // 经办人ID
    @TableField(value="operator_name")
    private String operatorName; // 经办人姓名
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(exist=false)
    @SubEntity(serviceName="enterpriseBankInfoService",pidName = "zhuId")
    private List<EnterpriseBankInfoEntity> enterpriseBankInfoList = new ArrayList<>(); // 企业银行信息
    
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public String getCorpTypeId() {
        return corpTypeId;
    }

    public void setCorpTypeId(String corpTypeId) {
        this.corpTypeId = corpTypeId;
    }
    public String getCorpTypeCode() {
        return corpTypeCode;
    }

    public void setCorpTypeCode(String corpTypeCode) {
        this.corpTypeCode = corpTypeCode;
    }
    public String getCorpTypeName() {
        return corpTypeName;
    }

    public void setCorpTypeName(String corpTypeName) {
        this.corpTypeName = corpTypeName;
    }
    public String getLicenseNum() {
        return licenseNum;
    }

    public void setLicenseNum(String licenseNum) {
        this.licenseNum = licenseNum;
    }
    public String getAreaId() {
        return areaId;
    }

    public void setAreaId(String areaId) {
        this.areaId = areaId;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }
    public Long getLegalManId() {
        return legalManId;
    }

    public void setLegalManId(Long legalManId) {
        this.legalManId = legalManId;
    }
    public String getLegalManName() {
        return legalManName;
    }

    public void setLegalManName(String legalManName) {
        this.legalManName = legalManName;
    }
    public String getLegalManDuty() {
        return legalManDuty;
    }

    public void setLegalManDuty(String legalManDuty) {
        this.legalManDuty = legalManDuty;
    }
    public String getLegaManProTitle() {
        return legaManProTitle;
    }

    public void setLegaManProTitle(String legaManProTitle) {
        this.legaManProTitle = legaManProTitle;
    }
    public String getLegalManIdCardTypeId() {
        return legalManIdCardTypeId;
    }

    public void setLegalManIdCardTypeId(String legalManIdCardTypeId) {
        this.legalManIdCardTypeId = legalManIdCardTypeId;
    }
    public String getLegalManIdCardTypeCode() {
        return legalManIdCardTypeCode;
    }

    public void setLegalManIdCardTypeCode(String legalManIdCardTypeCode) {
        this.legalManIdCardTypeCode = legalManIdCardTypeCode;
    }
    public String getLegalManIdCardTypeName() {
        return legalManIdCardTypeName;
    }

    public void setLegalManIdCardTypeName(String legalManIdCardTypeName) {
        this.legalManIdCardTypeName = legalManIdCardTypeName;
    }
    public String getLegalManIdCardNumber() {
        return legalManIdCardNumber;
    }

    public void setLegalManIdCardNumber(String legalManIdCardNumber) {
        this.legalManIdCardNumber = legalManIdCardNumber;
    }
    public BigDecimal getRegCapital() {
        return regCapital;
    }

    public void setRegCapital(BigDecimal regCapital) {
        this.regCapital = regCapital;
    }
    public BigDecimal getFactRegCapital() {
        return factRegCapital;
    }

    public void setFactRegCapital(BigDecimal factRegCapital) {
        this.factRegCapital = factRegCapital;
    }
    public String getCapitalCurrencyTypeId() {
        return capitalCurrencyTypeId;
    }

    public void setCapitalCurrencyTypeId(String capitalCurrencyTypeId) {
        this.capitalCurrencyTypeId = capitalCurrencyTypeId;
    }
    public String getCapitalCurrencyTypeCode() {
        return capitalCurrencyTypeCode;
    }

    public void setCapitalCurrencyTypeCode(String capitalCurrencyTypeCode) {
        this.capitalCurrencyTypeCode = capitalCurrencyTypeCode;
    }
    public String getCapitalCurrencyTypeName() {
        return capitalCurrencyTypeName;
    }

    public void setCapitalCurrencyTypeName(String capitalCurrencyTypeName) {
        this.capitalCurrencyTypeName = capitalCurrencyTypeName;
    }
    public Date getRegisterDate() {
        return registerDate;
    }

    public void setRegisterDate(Date registerDate) {
        this.registerDate = registerDate;
    }
    public Date getEstablishDate() {
        return establishDate;
    }

    public void setEstablishDate(Date establishDate) {
        this.establishDate = establishDate;
    }
    public String getOfficePhone() {
        return officePhone;
    }

    public void setOfficePhone(String officePhone) {
        this.officePhone = officePhone;
    }
    public String getFaxNumber() {
        return faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }
    public String getLinkMan() {
        return linkMan;
    }

    public void setLinkMan(String linkMan) {
        this.linkMan = linkMan;
    }
    public String getLinkPhone() {
        return linkPhone;
    }

    public void setLinkPhone(String linkPhone) {
        this.linkPhone = linkPhone;
    }
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
    public String getWebsite() {
        return website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }
    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public List<EnterpriseBankInfoEntity> getEnterpriseBankInfoList() {
        return enterpriseBankInfoList;
    }

    public void setEnterpriseBankInfoList(List<EnterpriseBankInfoEntity> enterpriseBankInfoList) {
        this.enterpriseBankInfoList = enterpriseBankInfoList;
    }
}
