/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.labor.bean.WorkerEnterChangeEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEnterRecordEntity;
import com.ejianc.business.labor.service.IWorkerEnterChangeService;
import com.ejianc.business.labor.service.IWorkerEnterRecordService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="workerEnterChange")
public class WorkerEnterChangeBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWorkerService workerService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IWorkerEnterChangeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IWorkerEnterService workerEnterService;
    @Autowired
    private IWorkerEnterRecordService workerEnterRecordService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private static final String ENTER_BILL_TYPE = "BT202211000003";
    private static final String CHANGE_BILL_TYPE = "BT202304000001";
    private static final String CHANGE_RECORD_BILL_TYPE = "BT202304000002";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u7ec8\u5ba1\u5ba1\u6838\u5b8c\u56de\u8c03\uff1a\u52b3\u52a1\u8fdb\u573a\u5355-\u53d8\u66f4\u5355\u636eid\uff1a{}\uff0c\u5355\u636e\u72b6\u6001\uff1a{}\uff0c\u5355\u636e\u7c7b\u578b\uff1a{}", new Object[]{billId, state, billTypeCode});
        WorkerEnterChangeEntity entity = (WorkerEnterChangeEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u5355\u636e\u4e0d\u5b58\u5728");
        }
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            entity.setCommitDate(new Date());
        }
        UserContext userContext = this.sessionManager.getUserContext();
        entity.setCommitUserCode(userContext.getUserCode());
        entity.setCommitUserName(userContext.getUserName());
        entity.setEffectiveDate(new Date());
        WorkerEnterEntity workerEnterEntity = (WorkerEnterEntity)((Object)this.workerEnterService.selectById(entity.getWorkerEnterId()));
        if (workerEnterEntity == null) {
            throw new BusinessException("\u52b3\u52a1\u8fdb\u573a\u5355\u4e0d\u5b58\u5728");
        }
        WorkerEnterRecordEntity recordEntity = (WorkerEnterRecordEntity)((Object)BeanMapper.map((Object)((Object)workerEnterEntity), WorkerEnterRecordEntity.class));
        recordEntity.setWorkerEnterId(workerEnterEntity.getId());
        Long recordId = IdWorker.getId();
        recordEntity.setId(recordId);
        recordEntity.setCreateUserCode(entity.getCreateUserCode());
        recordEntity.setCreateTime(entity.getCreateTime());
        recordEntity.setUpdateTime(entity.getUpdateTime());
        recordEntity.setUpdateUserCode(entity.getUpdateUserCode());
        recordEntity.setCurChangingId(workerEnterEntity.getCurChangingId());
        recordEntity.setChangeReason(entity.getChangeReason());
        recordEntity.setEffectiveDate(entity.getEffectiveDate());
        this.workerEnterRecordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("\u751f\u6210\u53d8\u66f4\u8bb0\u5f55\u5b8c\u6210");
        CommonResponse response = this.attachmentApi.copyFiles(workerEnterEntity.getId().toString(), ENTER_BILL_TYPE, null, recordId.toString(), CHANGE_RECORD_BILL_TYPE, null, true);
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        this.logger.info("\u751f\u6210\u53d8\u66f4\u8bb0\u5f55\u9644\u4ef6\u4fe1\u606f\u5b8c\u6210");
        this.service.saveOrUpdate((Object)entity, false);
        this.logger.info("\u66f4\u65b0\u53d8\u66f4\u5355\u636e\u72b6\u6001\u5b8c\u6210");
        WorkerEnterEntity workerEnter = (WorkerEnterEntity)((Object)BeanMapper.map((Object)((Object)entity), WorkerEnterEntity.class));
        workerEnter.setChangeState(WorkerEnterVO.CHANGE_STATE_CHANGED);
        workerEnter.setCurChangingId(null);
        workerEnter.setCreateUserCode(workerEnterEntity.getCreateUserCode());
        workerEnter.setCreateTime(workerEnterEntity.getCreateTime());
        workerEnter.setId(workerEnterEntity.getId());
        workerEnter.setDr(workerEnterEntity.getDr());
        workerEnter.setVersion(workerEnterEntity.getVersion());
        workerEnter.setChangeVersion(entity.getChangeVersion());
        workerEnter.setBillState(workerEnterEntity.getBillState());
        this.workerEnterService.saveOrUpdate((Object)workerEnter, false);
        this.logger.info("\u56de\u5199\u539f\u5355\u636e\u5b8c\u6210");
        CommonResponse response1 = this.attachmentApi.copyFiles(entity.getId().toString(), CHANGE_BILL_TYPE, null, workerEnterEntity.getId().toString(), ENTER_BILL_TYPE, null, true);
        if (!response1.isSuccess()) {
            throw new BusinessException(response1.getMsg());
        }
        this.logger.info("\u53d8\u66f4\u5355\u636e\u9644\u4ef6\u56de\u5199\u539f\u5355\u636e\u5b8c\u6210");
        WorkerEnterEntity workerEnter1 = (WorkerEnterEntity)((Object)this.workerEnterService.selectById(entity.getWorkerEnterId()));
        this.workerEnterService.bpmWriteBackAndInsert(workerEnter1);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u5f03\u5ba1\u540e\u4e0d\u652f\u6301\u64a4\u56de\uff01");
    }
}

