/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.other.dangong.service.api;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.service.IAttendanceLogService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.other.bean.EquipRecordsEntity;
import com.ejianc.business.other.dangong.service.DanGongPersonApiService;
import com.ejianc.business.other.dangong.vo.DanGongPersonAttendanceVO;
import com.ejianc.business.other.dangong.vo.DanGongPersonVO;
import com.ejianc.business.other.enums.ConTypeEnum;
import com.ejianc.business.other.henger.bean.HengErEquipEntity;
import com.ejianc.business.other.henger.service.IHengErEquipService;
import com.ejianc.business.other.henger.vo.HengErEquipVO;
import com.ejianc.business.other.service.IEquipRecordsService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DanGongPersonApiService")
public class DanGongPersonApiServiceImpl
implements DanGongPersonApiService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWorkRecordService workRecordService;
    @Autowired
    private IHengErEquipService hengErEquipService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IEquipRecordsService equipRecordsService;
    @Autowired
    private IAttendanceLogService attendanceLogService;

    @Override
    public List<DanGongPersonVO> workers(String deviceId, String productId, String update) {
        ArrayList<DanGongPersonVO> danGongPersonVOS;
        block26: {
            Long projectId;
            block25: {
                HengErEquipVO hengErEquipVO = this.hengErEquipService.selectByEquipSn(deviceId);
                projectId = hengErEquipVO.getProjectId();
                HengErEquipEntity entity = (HengErEquipEntity)((Object)BeanMapper.map((Object)hengErEquipVO, HengErEquipEntity.class));
                if (entity != null) {
                    if (entity.getEquipDate() != null) {
                        long hoursBetween = DateUtil.between((Date)entity.getEquipDate(), (Date)new Date(), (DateUnit)DateUnit.HOUR);
                        if (hoursBetween > 1L) {
                            entity.setEquipStatus("\u5728\u7ebf");
                            entity.setEquipDate(new Date());
                            this.hengErEquipService.saveOrUpdate((Object)entity);
                            this.logger.info("\u8bbe\u5907{}\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8ddd\u79bb\u4e0a\u6b21\u66f4\u65b0\u95f4\u9694{}\u5c0f\u65f6", (Object)entity.getEquipSn(), (Object)hoursBetween);
                        }
                    } else {
                        entity.setEquipStatus("\u5728\u7ebf");
                        entity.setEquipDate(new Date());
                        this.hengErEquipService.saveOrUpdate((Object)entity);
                        this.logger.info("\u8bbe\u5907{}\u72b6\u6001\u5df2\u521d\u59cb\u5316\u66f4\u65b0", (Object)entity.getEquipSn());
                    }
                }
                danGongPersonVOS = new ArrayList<DanGongPersonVO>();
                if (!"0".equals(update) && !StringUtils.isEmpty((CharSequence)update)) break block25;
                this.logger.info("\u5168\u91cf\u540c\u6b65\u5f00\u59cb1-------------");
                List list = this.workRecordService.list((Wrapper)Wrappers.lambdaQuery().eq(WorkRecordEntity::getProjectId, (Object)projectId));
                if (ListUtil.isNotEmpty((List)list)) {
                    for (WorkRecordEntity workRecordEntity : list) {
                        List fileData;
                        Map<Object, Object> fileIdRef = new HashMap();
                        CommonResponse listCommonResponse = this.attachmentApi.queryNoAuthListBySourceId(workRecordEntity.getId(), null, null, null);
                        if (listCommonResponse.isSuccess()) {
                            fileData = (List)listCommonResponse.getData();
                            if (ListUtil.isEmpty((List)fileData)) {
                                this.logger.info("\u65e0\u56fe\u7247\u4fe1\u606f\uff01");
                            }
                        } else {
                            throw new BusinessException("\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5f02\u5e38!");
                        }
                        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                        DanGongPersonVO danGongPersonVO = new DanGongPersonVO();
                        danGongPersonVO.setName(workRecordEntity.getName());
                        danGongPersonVO.setWorkerId(workRecordEntity.getWorkerId().toString());
                        String url = "https://pms.zzyjjt.com/" + ((AttachmentVO)fileIdRef.get(workRecordEntity.getId())).getFilePath();
                        danGongPersonVO.setPhoto(url);
                        if (workRecordEntity.getEnterExitState().equals(0)) {
                            danGongPersonVO.setDel("1");
                        } else {
                            danGongPersonVO.setDel("0");
                        }
                        danGongPersonVO.setIdCardNumber(workRecordEntity.getIdCard());
                        Date updateTime = new Date();
                        if (workRecordEntity.getUpdateTime() != null) {
                            updateTime = workRecordEntity.getUpdateTime();
                        } else if (workRecordEntity.getCreateTime() != null) {
                            updateTime = workRecordEntity.getCreateTime();
                        }
                        long time = updateTime.getTime() / 1000L;
                        danGongPersonVO.setUpdate(String.valueOf(time));
                        danGongPersonVOS.add(danGongPersonVO);
                    }
                }
                break block26;
            }
            this.logger.info("\u589e\u91cf\u540c\u6b65\u5f00\u59cb2-------------");
            DateTime date = DateUtil.date((long)(Long.parseLong(update) * 1000L)).offset(DateField.of((int)11), -24);
            List list = this.workRecordService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(WorkRecordEntity::getProjectId, (Object)projectId)).ge(BaseEntity::getCreateTime, (Object)date));
            if (!ListUtil.isNotEmpty((List)list)) break block26;
            for (WorkRecordEntity workRecordEntity : list) {
                DanGongPersonVO danGongPersonVO = new DanGongPersonVO();
                danGongPersonVO.setName(workRecordEntity.getName());
                danGongPersonVO.setWorkerId(workRecordEntity.getWorkerId().toString());
                if (StringUtils.isNotEmpty((CharSequence)workRecordEntity.getFileUrl())) {
                    String url = "https://pms.zzyjjt.com/" + workRecordEntity.getFileUrl();
                    danGongPersonVO.setPhoto(url);
                } else {
                    List fileData;
                    Map<Object, Object> fileIdRef = new HashMap();
                    CommonResponse listCommonResponse = this.attachmentApi.queryNoAuthListBySourceId(workRecordEntity.getId(), null, null, null);
                    if (listCommonResponse.isSuccess()) {
                        fileData = (List)listCommonResponse.getData();
                        if (ListUtil.isEmpty((List)fileData)) {
                            this.logger.info("\u65e0\u56fe\u7247\u4fe1\u606f\uff01");
                        }
                    } else {
                        throw new BusinessException("\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5f02\u5e38!");
                    }
                    fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
                    String url = "https://pms.zzyjjt.com/" + ((AttachmentVO)fileIdRef.get(workRecordEntity.getId())).getFilePath();
                    danGongPersonVO.setPhoto(url);
                }
                if (workRecordEntity.getEnterExitState().equals(0)) {
                    danGongPersonVO.setDel("1");
                } else {
                    danGongPersonVO.setDel("0");
                }
                danGongPersonVO.setIdCardNumber(workRecordEntity.getIdCard());
                Date updateTime = new Date();
                if (workRecordEntity.getUpdateTime() != null) {
                    updateTime = workRecordEntity.getUpdateTime();
                } else if (workRecordEntity.getCreateTime() != null) {
                    updateTime = workRecordEntity.getCreateTime();
                }
                long time = updateTime.getTime() / 1000L;
                danGongPersonVO.setUpdate(String.valueOf(time));
                danGongPersonVOS.add(danGongPersonVO);
            }
        }
        return danGongPersonVOS;
    }

    @Override
    public JSONObject getPhoto(DanGongPersonAttendanceVO vo) {
        List fileData;
        String time = vo.getTime();
        DateTime serviceDate = DateUtil.date((long)Long.parseLong(time));
        String deviceId = vo.getDeviceId();
        Long workerId = Long.parseLong(vo.getWorkerId());
        EquipRecordsEntity equipRecordsEntity = new EquipRecordsEntity();
        equipRecordsEntity.setEquipSn(deviceId);
        equipRecordsEntity.setWorkerId(workerId);
        equipRecordsEntity.setServiceDate((Date)serviceDate);
        equipRecordsEntity.setEquipType(ConTypeEnum.\u6052\u5c14\u5f39\u5f13.getStatus());
        this.equipRecordsService.saveOrUpdate((Object)equipRecordsEntity);
        HengErEquipVO hengErEquipVO = this.hengErEquipService.selectByEquipSn(deviceId);
        if (hengErEquipVO == null) {
            throw new BusinessException("\u8bbe\u5907\u4e3a\u7a7a\uff01");
        }
        String punchCardType = "1".equals(hengErEquipVO.getEnterType()) ? "\u4e0a\u73ed\u6253\u5361" : "\u4e0b\u73ed\u6253\u5361";
        this.attendanceLogService.synPunchCard(workerId, hengErEquipVO.getProjectId(), punchCardType, (Date)serviceDate);
        WorkRecordEntity workRecordEntity = (WorkRecordEntity)((Object)this.workRecordService.selectById(workerId));
        Map<Object, Object> fileIdRef = new HashMap();
        CommonResponse listCommonResponse = this.attachmentApi.queryNoAuthListBySourceId(workRecordEntity.getId(), null, null, null);
        if (listCommonResponse.isSuccess()) {
            fileData = (List)listCommonResponse.getData();
            if (ListUtil.isEmpty((List)fileData)) {
                this.logger.info("\u65e0\u56fe\u7247\u4fe1\u606f\uff01");
            }
        } else {
            throw new BusinessException("\u8bbf\u95ee\u6587\u4ef6\u670d\u52a1\u5f02\u5e38!");
        }
        fileIdRef = fileData.stream().filter(s -> s.getSourceType() != null && s.getSourceType().equals("face")).collect(Collectors.toMap(AttachmentVO::getSourceId, Function.identity()));
        DanGongPersonVO danGongPersonVO = new DanGongPersonVO();
        danGongPersonVO.setName(workRecordEntity.getName());
        danGongPersonVO.setWorkerId(workRecordEntity.getWorkerId().toString());
        String url = "https://pms.zzyjjt.com/" + ((AttachmentVO)fileIdRef.get(workRecordEntity.getId())).getFilePath();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("path", (Object)"");
        return jsonObject;
    }
}

