package com.ejianc.business.labor.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.labor.bean.WorkerEnterChangeEntity;
import com.ejianc.business.labor.bean.WorkerEnterEntity;
import com.ejianc.business.labor.bean.WorkerEntity;
import com.ejianc.business.labor.service.IWorkerEnterChangeService;
import com.ejianc.business.labor.service.IWorkerEnterService;
import com.ejianc.business.labor.service.IWorkerService;
import com.ejianc.business.labor.vo.WorkerEnterChangeVO;
import com.ejianc.business.labor.vo.WorkerEnterVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 劳务进场单
 *
 * @author baipengyan
 */
@RestController
@RequestMapping("workerEnterChange")
public class WorkerEnterChangeController implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWorkerEnterChangeService service;
    @Autowired
    private IWorkerEnterService workerEnterService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IWorkerService workerService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @PostMapping("saveOrUpdate")
    public CommonResponse<WorkerEnterChangeVO> saveOrUpdate(@RequestBody WorkerEnterChangeVO workerEnterChangeVO) {
        //校验项目是否存在未完成的变更计划单存在
        WorkerEnterChangeEntity planChangeEntity = service.getUnFinishedChange(workerEnterChangeVO.getWorkerEnterId());

        if(null !=planChangeEntity && (null == workerEnterChangeVO.getId() || !planChangeEntity.getId().equals(workerEnterChangeVO.getId()))) {
            return CommonResponse.error("保存失败，该项目存在未完成的变更计划！");
        }
        // 若存在未生效的退场单，对应的进场但也不能变更
        service.checkExit(workerEnterChangeVO);

        WorkerEnterEntity workerEnterEntity = workerEnterService.getById(workerEnterChangeVO.getWorkerEnterId());
        UserContext userContext = sessionManager.getUserContext();
        WorkerEnterChangeEntity saveEntity = null;

        saveEntity = BeanMapper.map(workerEnterChangeVO, WorkerEnterChangeEntity.class);
        //设置为自由态
        saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        //变更版本号
        saveEntity.setChangeVersion(workerEnterEntity.getChangeVersion() + 1);
        saveEntity.setCommitUserName(userContext.getUserName());
        //设置变更人
        saveEntity.setChangeUserName(userContext.getUserName());

        saveEntity.setBillCode(workerEnterEntity.getBillCode());
        saveEntity.setProjectName(workerEnterEntity.getProjectName());
        saveEntity.setOrgName(workerEnterEntity.getOrgName());
        saveEntity.setOrgId(workerEnterEntity.getOrgId());
        saveEntity.setCreateUserName(userContext.getUserName());

        saveEntity = service.saveOrUpdateChange(saveEntity);
        return CommonResponse.success("保存或修改单据成功！", BeanMapper.map(saveEntity, WorkerEnterChangeVO.class));
    }

    @PostMapping("saveCheck")
    public CommonResponse<JSONObject> saveCheck(@RequestBody WorkerEnterChangeVO workerEnterChangeVO) {
        WorkerEnterVO workerEnterVO = BeanMapper.map(workerEnterChangeVO, WorkerEnterVO.class);
        JSONObject jsonObject = new JSONObject();
        WorkerEntity recordOneByCard = workerService.queryOneByIdCard(workerEnterChangeVO.getIdCard());
        if (recordOneByCard != null) {
            jsonObject.put("level", 1);
            jsonObject.put("msg", "该用户在司花名册中已存在，本次进场将会修改公司花名册中该人员的基本信息，是否确定？");
            return CommonResponse.success(jsonObject);
        }
        jsonObject.put("level", 2);
        return CommonResponse.success(jsonObject);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @GetMapping("queryDetail")
    public CommonResponse<WorkerEnterChangeVO> queryDetail(Long id) {
        WorkerEnterChangeVO vo = new WorkerEnterChangeVO();
        WorkerEnterChangeEntity entity = service.selectById(id);
        if (entity != null) {
            vo = BeanMapper.map(entity, WorkerEnterChangeVO.class);
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @PostMapping("delete")
    public CommonResponse<String> delete(@RequestBody List<WorkerEnterChangeVO> vos) {
        service.deleteChangePlan(vos.stream().map(WorkerEnterChangeVO::getId).collect(Collectors.toList()));
        return CommonResponse.success("删除成功！");
    }


    @GetMapping("generateId")
    public CommonResponse<String> generateId() {
        return CommonResponse.success("生成分布式唯一id成功！", String.valueOf(IdWorker.getId()));
    }

}
