/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.labor.service.impl;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateRange;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.desktop.vo.AttendancePerLineVO;
import com.ejianc.business.labor.bean.AttendanceEntity;
import com.ejianc.business.labor.bean.WorkRecordEntity;
import com.ejianc.business.labor.mapper.AttendanceMapper;
import com.ejianc.business.labor.service.IAttendanceService;
import com.ejianc.business.labor.service.IWorkRecordService;
import com.ejianc.business.labor.vo.AttendanceDailyExportVO;
import com.ejianc.business.labor.vo.AttendanceVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tools.ant.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="attendanceService")
public class AttendanceServiceImpl
extends BaseServiceImpl<AttendanceMapper, AttendanceEntity>
implements IAttendanceService {
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IWorkRecordService workRecordService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public int totalAttendanceDays(Date enterDate, Date exitDate, Long workerId, Long projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.eq((Object)"worker_id", (Object)workerId);
        queryWrapper.between((Object)"punch_card_date", (Object)enterDate, (Object)exitDate);
        int count = super.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public IPage<AttendanceEntity> queryPageByPerson(Page<AttendanceEntity> p, QueryWrapper<AttendanceEntity> wrapper, String startDate, String endDate) {
        return ((AttendanceMapper)this.baseMapper).queryPageByPerson(p, wrapper, startDate, endDate);
    }

    @Override
    public Integer queryAttendanceOrgIds(String orgIds) {
        return ((AttendanceMapper)this.baseMapper).queryAttendanceOrgIds(orgIds);
    }

    @Override
    public IPage<AttendanceVO> queryDailyAttendancePage(Page<AttendanceVO> p, QueryWrapper<AttendanceVO> wrapper) {
        return ((AttendanceMapper)this.baseMapper).queryDailyAttendancePage(p, wrapper);
    }

    @Override
    public List<AttendanceVO> queryDailyAttendanceList(QueryWrapper<AttendanceVO> wrapper) {
        return ((AttendanceMapper)this.baseMapper).queryDailyAttendanceList(wrapper);
    }

    @Override
    public IPage<AttendanceVO> queryAllAttendanceRecord(Page<AttendanceVO> p, QueryWrapper<AttendanceVO> wrapper) {
        return ((AttendanceMapper)this.baseMapper).queryAllAttendanceRecord(p, wrapper);
    }

    @Override
    public List<AttendancePerLineVO> queryAttendancePerLine(QueryWrapper<AttendanceVO> wrapper) {
        return ((AttendanceMapper)this.baseMapper).queryAttendancePerLine(wrapper);
    }

    @Override
    public JSONObject queryDailyAttendanceExport(QueryParam param) {
        String employeeName;
        QueryParam copyParam = new QueryParam();
        if (param.getParams().containsKey("punchCardDate")) {
            copyParam.getParams().put("punchCardDate", param.getParams().get("punchCardDate"));
            param.getParams().remove("punchCardDate");
        }
        param.getOrderMap().putIfAbsent("enter_date", "desc");
        IPage page = this.workRecordService.queryPage(param, false);
        List workRecordEntities = page.getRecords();
        if (ListUtil.isEmpty((List)workRecordEntities)) {
            JSONObject pageData = new JSONObject();
            pageData.put("records", Collections.emptyList());
            pageData.put("total", (Object)page.getTotal());
            pageData.put("current", (Object)page.getCurrent());
            pageData.put("size", (Object)page.getSize());
            return pageData;
        }
        List workerIds = workRecordEntities.stream().map(WorkRecordEntity::getWorkerId).distinct().collect(Collectors.toList());
        if (ListUtil.isNotEmpty(workerIds)) {
            copyParam.getParams().put("workerId", new Parameter("in", workerIds));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (copyParam.getParams().get("punchCardDate") != null) {
            String punchCardDate = ((Parameter)copyParam.getParams().get("punchCardDate")).getValue().toString();
            if (punchCardDate.split(",").length == 1) {
                copyParam.getParams().remove("punchCardDate");
                queryWrapper = AttendanceServiceImpl.changeToQueryWrapper((QueryParam)copyParam);
                queryWrapper.apply("date_format(punch_card_date,'%Y-%m') = {0}", new Object[]{punchCardDate});
            } else {
                queryWrapper = AttendanceServiceImpl.changeToQueryWrapper((QueryParam)copyParam);
            }
        } else {
            queryWrapper = AttendanceServiceImpl.changeToQueryWrapper((QueryParam)copyParam);
        }
        List<AttendanceDailyExportVO> records = ((AttendanceMapper)this.baseMapper).queryDailyAttendanceExport((QueryWrapper<AttendanceDailyExportVO>)queryWrapper);
        this.logger.info("1---------\u67e5\u8be2\u539f\u59cb\u5bfc\u51fa\u6570\u636e\u4e3a{}", (Object)JSONObject.toJSONString(records));
        HashMap<Long, String> workerIdToNameMap = new HashMap<Long, String>();
        for (Object workRecord : workRecordEntities) {
            workerIdToNameMap.put(((WorkRecordEntity)((Object)workRecord)).getWorkerId(), ((WorkRecordEntity)((Object)workRecord)).getName());
        }
        HashMap<String, Map> employeeAttendanceMap = new HashMap<String, Map>();
        for (AttendanceDailyExportVO attendanceDailyExportVO : records) {
            Long workerId = attendanceDailyExportVO.getId();
            employeeName = (String)workerIdToNameMap.get(workerId);
            if (employeeName == null) continue;
            String dateKey = DateUtils.format((Date)attendanceDailyExportVO.getWorkDate(), (String)"yyyy-MM-dd");
            double workHours = attendanceDailyExportVO.getWorkHours();
            Map dateMap = employeeAttendanceMap.computeIfAbsent(employeeName, k -> new HashMap());
            dateMap.put(dateKey, workHours);
        }
        ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
        for (WorkRecordEntity workRecordEntity : workRecordEntities) {
            employeeName = workRecordEntity.getName();
            JSONObject employeeJson = new JSONObject();
            employeeJson.put("name", (Object)employeeName);
            employeeJson.put("idCard", (Object)workRecordEntity.getIdCard());
            employeeJson.put("phone", (Object)workRecordEntity.getPhone());
            employeeJson.put("teamName", (Object)workRecordEntity.getTeamName());
            employeeJson.put("projectName", (Object)workRecordEntity.getProjectName());
            Map dateMap = (Map)employeeAttendanceMap.get(employeeName);
            if (dateMap != null && !dateMap.isEmpty()) {
                List sortedDates = dateMap.keySet().stream().sorted().collect(Collectors.toList());
                for (String date : sortedDates) {
                    employeeJson.put(date, (Object)((Double)dateMap.get(date)).toString());
                }
            }
            resultList.add(employeeJson);
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("records", resultList);
        jSONObject.put("total", (Object)page.getTotal());
        jSONObject.put("current", (Object)page.getCurrent());
        jSONObject.put("size", (Object)page.getSize());
        return jSONObject;
    }

    @Override
    public List<AttendanceDailyExportVO> queryDailyAttendanceExportExcel(QueryParam param) {
        QueryParam copyParam = new QueryParam();
        if (param.getParams().containsKey("punchCardDate")) {
            copyParam.getParams().put("punchCardDate", param.getParams().get("punchCardDate"));
            param.getParams().remove("punchCardDate");
        }
        param.getOrderMap().putIfAbsent("enter_date", "desc");
        IPage page = this.workRecordService.queryPage(param, false);
        List workRecordEntities = page.getRecords();
        if (ListUtil.isEmpty((List)workRecordEntities)) {
            return new ArrayList<AttendanceDailyExportVO>();
        }
        List workerIds = workRecordEntities.stream().map(WorkRecordEntity::getWorkerId).distinct().collect(Collectors.toList());
        if (ListUtil.isNotEmpty(workerIds)) {
            copyParam.getParams().put("workerId", new Parameter("in", workerIds));
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (copyParam.getParams().get("punchCardDate") != null) {
            String punchCardDate = ((Parameter)copyParam.getParams().get("punchCardDate")).getValue().toString();
            if (punchCardDate.split(",").length == 1) {
                copyParam.getParams().remove("punchCardDate");
                queryWrapper = AttendanceServiceImpl.changeToQueryWrapper((QueryParam)copyParam);
                queryWrapper.apply("date_format(punch_card_date,'%Y-%m') = {0}", new Object[]{punchCardDate});
            } else {
                queryWrapper = AttendanceServiceImpl.changeToQueryWrapper((QueryParam)copyParam);
            }
        } else {
            queryWrapper = AttendanceServiceImpl.changeToQueryWrapper((QueryParam)copyParam);
        }
        List<AttendanceDailyExportVO> records = ((AttendanceMapper)this.baseMapper).queryDailyAttendanceExport((QueryWrapper<AttendanceDailyExportVO>)queryWrapper);
        this.logger.info("1---------\u67e5\u8be2\u539f\u59cb\u5bfc\u51fa\u6570\u636e\u4e3a{}", (Object)JSONObject.toJSONString(records));
        HashMap<Long, String> workerIdToNameMap = new HashMap<Long, String>();
        String punchCardDate = ((Parameter)copyParam.getParams().get("punchCardDate")).getValue().toString();
        String[] dates = punchCardDate.split(",");
        if (dates.length != 2) {
            throw new BusinessException("\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        DateTime startDate = DateUtil.parseDate((String)dates[0]);
        DateTime endDate = DateUtil.parseDate((String)dates[1]);
        List<String> allDateKeys = this.generateDateRangeKeys((Date)startDate, (Date)endDate);
        for (WorkRecordEntity workRecord : workRecordEntities) {
            workerIdToNameMap.put(workRecord.getWorkerId(), workRecord.getName());
        }
        LinkedHashMap employeeAttendanceMap = new LinkedHashMap();
        LinkedHashMap employeeAttendanceList = new LinkedHashMap();
        for (String employeeName : workerIdToNameMap.values()) {
            LinkedHashMap<String, Double> dateMap = new LinkedHashMap<String, Double>();
            ArrayList<Double> hourList = new ArrayList<Double>();
            for (String dateKey : allDateKeys) {
                dateMap.put(dateKey, 0.0);
                hourList.add(0.0);
            }
            employeeAttendanceMap.put(employeeName, dateMap);
            employeeAttendanceList.put(employeeName, hourList);
        }
        for (AttendanceDailyExportVO record : records) {
            int index;
            List hourList;
            Long workerId = record.getId();
            String employeeName = (String)workerIdToNameMap.get(workerId);
            if (employeeName == null) continue;
            String dateKey = DateUtils.format((Date)record.getWorkDate(), (String)"yyyy-MM-dd");
            double workHours = record.getWorkHours();
            Map dateMap = (Map)employeeAttendanceMap.get(employeeName);
            if (dateMap != null) {
                dateMap.put(dateKey, workHours);
            }
            if ((hourList = (List)employeeAttendanceList.get(employeeName)) == null || (index = allDateKeys.indexOf(dateKey)) == -1) continue;
            hourList.set(index, workHours);
        }
        ArrayList<JSONObject> resultListJSON = new ArrayList<JSONObject>();
        ArrayList<AttendanceDailyExportVO> resultList = new ArrayList<AttendanceDailyExportVO>();
        for (WorkRecordEntity workRecordEntity : workRecordEntities) {
            String employeeName = workRecordEntity.getName();
            JSONObject employeeJson = new JSONObject();
            employeeJson.put("name", (Object)employeeName);
            employeeJson.put("idCard", (Object)workRecordEntity.getIdCard());
            employeeJson.put("phone", (Object)workRecordEntity.getPhone());
            employeeJson.put("teamName", (Object)workRecordEntity.getTeamName());
            employeeJson.put("projectName", (Object)workRecordEntity.getProjectName());
            Map dateMap = (Map)employeeAttendanceMap.get(employeeName);
            if (dateMap != null && !dateMap.isEmpty()) {
                List sortedDates = dateMap.keySet().stream().sorted().collect(Collectors.toList());
                LinkedHashMap dynamicData = new LinkedHashMap();
                ArrayList<String> dynamicValues = new ArrayList<String>();
                for (String date : sortedDates) {
                    employeeJson.put(date, (Object)((Double)dateMap.get(date)).toString());
                    dynamicValues.add(((Double)dateMap.get(date)).toString());
                }
                employeeJson.put("dynamicValues", dynamicValues);
            }
            resultListJSON.add(employeeJson);
        }
        for (JSONObject jsonObject : resultListJSON) {
            AttendanceDailyExportVO employeeVO = new AttendanceDailyExportVO();
            employeeVO.setName(jsonObject.getString("name"));
            employeeVO.setIdCard(jsonObject.getString("idCard"));
            employeeVO.setPhone(jsonObject.getString("phone"));
            employeeVO.setTeamName(jsonObject.getString("teamName"));
            employeeVO.setProjectName(jsonObject.getString("projectName"));
            employeeVO.setDynamicValues(jsonObject.getJSONArray("dynamicValues").toJavaList(String.class));
            resultList.add(employeeVO);
        }
        return resultList;
    }

    public List<String> generateDateRangeKeys(Date startDate, Date endDate) {
        ArrayList<String> dateKeys = new ArrayList<String>();
        DateRange range = DateUtil.range((Date)startDate, (Date)endDate, (DateField)DateField.DAY_OF_YEAR);
        for (DateTime dateTime : range) {
            String dateKey = dateTime.toString("yyyy-MM-dd");
            dateKeys.add(dateKey);
        }
        return dateKeys;
    }
}

