package com.ejianc.business.cost.service;

import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.openapi.cost.vo.ProductDataVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.cost.bean.DatasummaryEntity;

import java.util.List;

/**
 * 数据汇总
 * 
 * @author generator
 * 
 */
public interface IDatasummaryService extends IBaseService<DatasummaryEntity> {
    /**
     * 同步生成生产数据
     * @param productDataVOS 生产数据列表
     */
    List<DatasummaryEntity> synchronizeData(List<ProductDataVO> productDataVOS);

    /**
     * 按原材料分组汇总原材料的耗用量
     * @param productTime 生产日期
     * @param orgId 组织id
     * @return 原材料耗用量汇总列表
     */
    List<MaterialUseTotalVO> queryMaterialUseTotal(String productTime,String orgId);
}
