package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.*;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.openapi.cost.vo.ProductDataVO;
import com.ejianc.business.cost.service.IMixtureratioService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.DatasummaryMapper;
import com.ejianc.business.cost.service.IDatasummaryService;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;

/**
 * 数据汇总
 * 
 * @author generator
 * 
 */
@Service("datasummaryService")
public class DatasummaryServiceImpl extends BaseServiceImpl<DatasummaryMapper, DatasummaryEntity> implements IDatasummaryService{

    @Autowired
    private IMixtureratioService service;
    @Autowired
    private IDatasummaryService datasummaryService;
    @Autowired
    private DatasummaryMapper mapper;
    /**
     * 生产数据同步
     * 根据生产配比名称查询生产配比信息
     * 查询到以后骨料的的用量按照投放比例计算得到
     *
     */
    @Override
    public List<DatasummaryEntity> synchronizeData(List<ProductDataVO> productDataVOS){
        List<DatasummaryEntity> datasummaryEntities=new ArrayList<>();
        if (!productDataVOS.isEmpty()){
            for (ProductDataVO productDataVO : productDataVOS) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq("name",productDataVO.getMixRateName());
                queryWrapper.eq("org_id",productDataVO.getOrgId());
                MixtureratioEntity mixtureratioEntity = service.getOne(queryWrapper);
                if (mixtureratioEntity!=null){
                    MixtureratioEntity entity = service.selectById(mixtureratioEntity.getId());
                    DatasummaryEntity datasummaryEntity = BeanMapper.map(entity, DatasummaryEntity.class);
                    datasummaryEntity.setId(null);
                    datasummaryEntity.setProductionMixtureId(entity.getId());
                    datasummaryEntity.setProductionMixtureName(entity.getName());
                    datasummaryEntity.setProductTime(new Date());
                    List<DatasummarydetailEntity> list=new ArrayList<>();
                    /**
                     * 骨料生产数据计算逻辑:
                     * 查询骨料的用量，计算骨料的每个原材料占整个骨料投放的占比，每个骨料的原材料的用量=骨料消耗*占比
                     */
                    if (!entity.getAggregate1DetailEntities().isEmpty()){
                        for (Aggregate1DetailEntity aggregateDetailEntity : entity.getAggregate1DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate1DetailEntity Entity :
                                    entity.getAggregate1DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAggregate1()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAggregate2DetailEntities().isEmpty()){
                        for (Aggregate2DetailEntity aggregateDetailEntity : entity.getAggregate2DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate2DetailEntity Entity : entity.getAggregate2DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAggregate2()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAggregate3DetailEntities().isEmpty()){
                        for (Aggregate3DetailEntity aggregateDetailEntity : entity.getAggregate3DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate3DetailEntity Entity : entity.getAggregate3DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAggregate3()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAggregate4DetailEntities().isEmpty()){
                        for (Aggregate4DetailEntity aggregateDetailEntity : entity.getAggregate4DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate4DetailEntity Entity : entity.getAggregate4DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAggregate4()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAggregate5DetailEntities().isEmpty()){
                        for (Aggregate5DetailEntity aggregateDetailEntity : entity.getAggregate5DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate5DetailEntity Entity : entity.getAggregate5DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAggregate5()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAggregate6DetailEntities().isEmpty()){
                        for (Aggregate6DetailEntity aggregateDetailEntity : entity.getAggregate6DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate6DetailEntity Entity : entity.getAggregate6DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAggregate6()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAggregate7DetailEntities().isEmpty()){
                        for (Aggregate7DetailEntity aggregateDetailEntity : entity.getAggregate7DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate7DetailEntity Entity : entity.getAggregate7DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAggregate7()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAggregate8DetailEntities().isEmpty()){
                        for (Aggregate8DetailEntity aggregateDetailEntity : entity.getAggregate8DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate8DetailEntity Entity : entity.getAggregate8DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAggregate8()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAggregate9DetailEntities().isEmpty()){
                        for (Aggregate9DetailEntity aggregateDetailEntity : entity.getAggregate9DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate9DetailEntity Entity : entity.getAggregate9DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(
                                    productDataVO.getAggregate9().multiply(percent)
                            );
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAggregate10DetailEntities().isEmpty()){
                        for (Aggregate10DetailEntity aggregateDetailEntity : entity.getAggregate10DetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (Aggregate10DetailEntity Entity : entity.getAggregate10DetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAggregate10()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAdmixtureDetailEntities().isEmpty()){
                        for (AdmixtureDetailEntity aggregateDetailEntity : entity.getAdmixtureDetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getUnitSum()
                                    .multiply(aggregateDetailEntity.getMaterialThrowPercent())
                                    .divide(BigDecimal.TEN.multiply(BigDecimal.TEN),2, RoundingMode.HALF_UP));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getOldMaterialDetailEntities().isEmpty()){
                        for (OldMaterialDetailEntity aggregateDetailEntity : entity.getOldMaterialDetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (OldMaterialDetailEntity Entity : entity.getOldMaterialDetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(1);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getOldMaterialSum()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getPowderDetailEntities().isEmpty()){
                        for (PowderDetailEntity aggregateDetailEntity : entity.getPowderDetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (PowderDetailEntity Entity : entity.getPowderDetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getMineralPowder()
                                    .multiply(percent)
                                    .divide(BigDecimal.TEN.multiply(BigDecimal.TEN),2, RoundingMode.HALF_UP));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAsphaltDetailEntities().isEmpty()){
                        for (AsphaltDetailEntity aggregateDetailEntity : entity.getAsphaltDetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (AsphaltDetailEntity Entity : entity.getAsphaltDetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAsphalt()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    if (!entity.getAsphaltsDetailEntities().isEmpty()){
                        for (AsphaltsDetailEntity aggregateDetailEntity : entity.getAsphaltsDetailEntities()) {
                            DatasummarydetailEntity datasummarydetailEntity=
                                    BeanMapper.map(aggregateDetailEntity,DatasummarydetailEntity.class);
                            datasummarydetailEntity.setId(null);
                            datasummarydetailEntity.setMid(null);
                            //计算骨料的投放综合再计算每个骨料占总和的投放比例
                            BigDecimal percentCount = new BigDecimal("0");
                            for (AsphaltsDetailEntity Entity : entity.getAsphaltsDetailEntities()) {
                                percentCount=percentCount.add(Entity.getMaterialThrowPercent());
                            }
                            BigDecimal percent=aggregateDetailEntity.getMaterialThrowPercent()
                                    .divide(percentCount,2, RoundingMode.HALF_UP);
                            datasummarydetailEntity.setIsOldMaterial(0);
                            datasummarydetailEntity.setMaterialUseTotal(productDataVO.getAsphalt()
                                    .multiply(percent));
                            list.add(datasummarydetailEntity);
                        }
                    }
                    datasummaryEntity.setDatasummarydetailList(list);
                    datasummaryService.saveOrUpdate(datasummaryEntity,false);
                    datasummaryEntities.add(datasummaryEntity);
                }
            }
        }
        return datasummaryEntities;
    }

    /**
     * 汇总查询原材料的消耗总量
     * @return
     */
    @Override
    public List<MaterialUseTotalVO> queryMaterialUseTotal(String productTime,String orgId) {
        Map<String, String> map = new HashMap<>();
        map.put("productTime",productTime);
        map.put("orgId",orgId);
        List<MaterialUseTotalVO> materialUseTotalVOS = mapper.queryMaterialUseTotal(map);
        return materialUseTotalVOS;
    }


}
