package com.ejianc.business.cost.service.impl;

import com.ejianc.business.cost.mapper.MaterialBuyMapper;
import com.ejianc.business.cost.service.IDatasummaryService;
import com.ejianc.business.cost.service.IMaterialBuyService;
import com.ejianc.business.cost.vo.MaterialUseTotalVO;
import com.ejianc.business.purchasingmanagement.api.SelectApi;
import com.ejianc.business.purchasingmanagement.vo.MaterialAcceptanceVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.cost.bean.MaterialBuyEntity;
import java.util.ArrayList;
import java.util.List;

/**
 * 本期购入数量
 * 
 * @author generator
 * 
 */
@Service("materialBuyService")
public class MaterialBuyServiceImpl extends BaseServiceImpl<MaterialBuyMapper, MaterialBuyEntity> implements IMaterialBuyService {
    @Autowired
    private IDatasummaryService datasummaryService;
    @Autowired
    private SelectApi api;
    @Autowired
    private IMaterialBuyService service;

    /**
     *
     * @param productTime 生产日期
     * @param orgId 组织id
     */
    @Override
    public void generateMaterialBuy(String productTime, String orgId) {
        List<MaterialBuyEntity> materialBuyEntities = new ArrayList<>();
        //按生产日期和组织查询原材料分子汇总数量
        List<MaterialUseTotalVO> materialUseTotalVOS = datasummaryService.queryMaterialUseTotal(productTime,orgId);

        if (!materialBuyEntities.isEmpty()){
            for (MaterialUseTotalVO materialUseTotalVO : materialUseTotalVOS) {
                //查询每个原材料的本期购入数据
                CommonResponse<MaterialAcceptanceVO> commonResponse = api.queryMaterialAcceptance(
                        materialUseTotalVO.getMaterialId().toString(),
                        materialUseTotalVO.getProductTime().toString()
                );
                if (commonResponse.getCode() == 0){
                    MaterialAcceptanceVO data = commonResponse.getData();
                    MaterialBuyEntity entity = BeanMapper.map(materialUseTotalVO, MaterialBuyEntity.class);
                    entity.setBuyDate(materialUseTotalVO.getProductTime());
                    entity.setAccount(data.getAcceptanceQuantity());
                    entity.setAmount(data.getAmount());
                    entity.setPrice(data.getPrice());
                    materialBuyEntities.add(entity);
                }
            }
        }
        service.saveBatch(materialBuyEntities);
    }
}
