package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.bean.MaterialInventorySummaryEntity;
import com.ejianc.business.cost.bean.MaterialStartInventoryEntity;
import com.ejianc.business.cost.mapper.MaterialInventorySummaryMapper;
import com.ejianc.business.cost.service.IMaterialInventorySummaryService;
import com.ejianc.business.cost.service.IMaterialStartInventoryService;
import com.ejianc.business.cost.vo.MaterialInventorySummaryVO;
import com.ejianc.business.cost.vo.MaterialInventoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import java.math.BigDecimal;

import java.util.List;

/**
 * 盘点汇总表
 *
 * @author generator
 */
@Service("materialInventorySummaryService")
public class MaterialInventorySummaryServiceImpl extends BaseServiceImpl<MaterialInventorySummaryMapper, MaterialInventorySummaryEntity> implements IMaterialInventorySummaryService {
    @Autowired
    IMaterialStartInventoryService service;
    @Autowired
    IMaterialInventorySummaryService materialInventorySummaryService;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "materialInventory-sum";//此处需要根据实际修改

    @Override
    public void saveMaterialInventorySummaryEntity(MaterialInventoryVO materialInventoryVO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("material_Id", materialInventoryVO.getMaterialId());
        queryWrapper.eq("category_id",materialInventoryVO.getCategoryId());
        queryWrapper.eq("material_varieties_id", materialInventoryVO.getMaterialVarietiesId());
        queryWrapper.eq("org_id", materialInventoryVO.getOrgId());
        queryWrapper.orderByAsc("create_time");
        List<MaterialStartInventoryEntity> list = service.list(queryWrapper);
        if (!list.isEmpty()) {
            MaterialStartInventoryEntity materialStartInventoryEntity = list.get(0);
            MaterialInventorySummaryEntity materialInventorySummaryEntity
                    = new MaterialInventorySummaryEntity();
            //原材料id
            materialInventorySummaryEntity.setMaterialId
                    (materialStartInventoryEntity.getMaterialId());
            //原材料名称
            materialInventorySummaryEntity.setMaterialName
                    (materialStartInventoryEntity.getMaterialName());
            //原材料品种id
            materialInventorySummaryEntity.setMaterialVarietiesId
                    (materialStartInventoryEntity.getMaterialVarietiesId());
            //原材料核算品种
            materialInventorySummaryEntity.setMaterialVarietiesName
                    (materialStartInventoryEntity.getMaterialVarietiesName());
            // 盘点数量
            materialInventorySummaryEntity.setInventoryQuantity
                    (materialInventoryVO.getMaterialAccount());

            //当前账面数量
            materialInventorySummaryEntity.setCurrentQuantity
                    (materialStartInventoryEntity.getMaterialAccount());
            //盘点汇总 单价
            materialInventorySummaryEntity.setPrice
                    (materialStartInventoryEntity.getInventoryUnitPrice());
            //盘点金额  单价*盘点数量
            BigDecimal price = materialInventorySummaryEntity.getPrice();
            BigDecimal inventoryQuantity = materialInventorySummaryEntity.getInventoryQuantity(); //盘点数量
            BigDecimal inventoryAccount = price.multiply(inventoryQuantity);
            materialInventorySummaryEntity.setInventoryAccount(inventoryAccount);
            //当前帐面金额  单价*账面数量
            BigDecimal currentQuantity = materialInventorySummaryEntity.getCurrentQuantity();
            BigDecimal currentAmount = price.multiply(currentQuantity);
            materialInventorySummaryEntity.setCurrentAmount(currentAmount);
            //盈亏金额
            BigDecimal profitLossAmount = inventoryAccount.subtract(currentAmount);
            materialInventorySummaryEntity.setProfitLossAmount(profitLossAmount);
            //盈亏数量
            BigDecimal profitLossQuantity = inventoryQuantity.subtract(currentQuantity);
            materialInventorySummaryEntity.setProfitLossQuantity(profitLossQuantity);
            //备注
            materialInventorySummaryEntity.setRemark(materialStartInventoryEntity.getRemark());
            //组织id
            materialInventorySummaryEntity.setOrgId(materialStartInventoryEntity.getOrgId());
            //单据编号
            MaterialInventorySummaryVO saveOrUpdateVO = BeanMapper.map(materialInventorySummaryEntity, MaterialInventorySummaryVO.class);
            if(materialInventorySummaryEntity.getId() == null || materialInventorySummaryEntity.getId() == 0){
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    //entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                    materialInventorySummaryEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常，编码生成失败，请稍后再试");
                }
            }
            //保存
            materialInventorySummaryService.save(materialInventorySummaryEntity);
        }
    }
}
