package com.ejianc.business.environment.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.environment.vo.SourcedetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 污染源头登记
 * 
 * @author generator
 * 
 */
public class SourceregistrationVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private String facilityName; // 污染防治设施名称
    private String facilityModel; // 污染防治设施型号
    private BigDecimal designValue; // 防治设施设计值
    private Long environmentFactorId; // 污染因子id
    private String environmentFactorName; // 污染因子名称
    private BigDecimal exhaustFunnelHigh; // 排气筒高度
    private BigDecimal exhaustFunnelDiameter; // 排气筒直径
    private String address; // 地址
    private BigDecimal longitude; // 经度
    private BigDecimal latitude; // 纬度
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private String parameterName; // 参数名称
    private String equipmentNumber; // 设备编号

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date validTime; // 有效日期
    
    private List<SourcedetailVO> sourcedetailList = new ArrayList<>(); // 污染源头登记子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }
    public String getFacilityModel() {
        return facilityModel;
    }

    public void setFacilityModel(String facilityModel) {
        this.facilityModel = facilityModel;
    }
    public BigDecimal getDesignValue() {
        return designValue;
    }

    public void setDesignValue(BigDecimal designValue) {
        this.designValue = designValue;
    }
    public Long getEnvironmentFactorId() {
        return environmentFactorId;
    }

    public void setEnvironmentFactorId(Long environmentFactorId) {
        this.environmentFactorId = environmentFactorId;
    }
    public String getEnvironmentFactorName() {
        return environmentFactorName;
    }

    public void setEnvironmentFactorName(String environmentFactorName) {
        this.environmentFactorName = environmentFactorName;
    }
    public BigDecimal getExhaustFunnelHigh() {
        return exhaustFunnelHigh;
    }

    public void setExhaustFunnelHigh(BigDecimal exhaustFunnelHigh) {
        this.exhaustFunnelHigh = exhaustFunnelHigh;
    }
    public BigDecimal getExhaustFunnelDiameter() {
        return exhaustFunnelDiameter;
    }

    public void setExhaustFunnelDiameter(BigDecimal exhaustFunnelDiameter) {
        this.exhaustFunnelDiameter = exhaustFunnelDiameter;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }
    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public String getParameterName() {
        return parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }
    public String getEquipmentNumber() {
        return equipmentNumber;
    }

    public void setEquipmentNumber(String equipmentNumber) {
        this.equipmentNumber = equipmentNumber;
    }
    public Date getValidTime() {
        return validTime;
    }

    public void setValidTime(Date validTime) {
        this.validTime = validTime;
    }
    
     public List<SourcedetailVO> getSourcedetailList() {
        return sourcedetailList;
     }

     public void setSourcedetailList(List<SourcedetailVO> sourcedetailList) {
        this.sourcedetailList = sourcedetailList;
     }
}
