package com.ejianc.business.environment.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.environment.bean.SourcedetailEntity;
/**
 * 污染源头登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_environment_source_registration")
public class SourceregistrationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="facility_name")
    private String facilityName; // 污染防治设施名称
    @TableField(value="facility_model")
    private String facilityModel; // 污染防治设施型号
    @TableField(value="design_value")
    private BigDecimal designValue; // 防治设施设计值
    @TableField(value="environment_factor_id")
    private Long environmentFactorId; // 污染因子id
    @TableField(value="environment_factor_name")
    private String environmentFactorName; // 污染因子名称
    @TableField(value="exhaust_funnel_high")
    private BigDecimal exhaustFunnelHigh; // 排气筒高度
    @TableField(value="exhaust_funnel_diameter")
    private BigDecimal exhaustFunnelDiameter; // 排气筒直径
    @TableField(value="address")
    private String address; // 地址
    @TableField(value="longitude")
    private String longitude; // 经度
    @TableField(value="latitude")
    private String latitude; // 纬度
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="change_id")
    private Long changeId; // 变更单据id
    @TableField(value="change_state")
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    @TableField(value="parameter_name")
    private String parameterName; // 参数名称
    @TableField(value="equipment_number")
    private String equipmentNumber; // 设备编号
    @TableField(value="valid_time")
    private Date validTime; // 有效日期
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="sourcedetailService",pidName = "mid")//此处有pid="xxx"，默认值pid="pid"
    private List<SourcedetailEntity> sourcedetailList = new ArrayList<>(); // 污染源头登记子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }
    public String getFacilityModel() {
        return facilityModel;
    }

    public void setFacilityModel(String facilityModel) {
        this.facilityModel = facilityModel;
    }
    public BigDecimal getDesignValue() {
        return designValue;
    }

    public void setDesignValue(BigDecimal designValue) {
        this.designValue = designValue;
    }
    public Long getEnvironmentFactorId() {
        return environmentFactorId;
    }

    public void setEnvironmentFactorId(Long environmentFactorId) {
        this.environmentFactorId = environmentFactorId;
    }
    public String getEnvironmentFactorName() {
        return environmentFactorName;
    }

    public void setEnvironmentFactorName(String environmentFactorName) {
        this.environmentFactorName = environmentFactorName;
    }
    public BigDecimal getExhaustFunnelHigh() {
        return exhaustFunnelHigh;
    }

    public void setExhaustFunnelHigh(BigDecimal exhaustFunnelHigh) {
        this.exhaustFunnelHigh = exhaustFunnelHigh;
    }
    public BigDecimal getExhaustFunnelDiameter() {
        return exhaustFunnelDiameter;
    }

    public void setExhaustFunnelDiameter(BigDecimal exhaustFunnelDiameter) {
        this.exhaustFunnelDiameter = exhaustFunnelDiameter;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }
    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public String getParameterName() {
        return parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }
    public String getEquipmentNumber() {
        return equipmentNumber;
    }

    public void setEquipmentNumber(String equipmentNumber) {
        this.equipmentNumber = equipmentNumber;
    }
    public Date getValidTime() {
        return validTime;
    }

    public void setValidTime(Date validTime) {
        this.validTime = validTime;
    }
    
    public List<SourcedetailEntity> getSourcedetailList() {
        return sourcedetailList;
    }

    public void setSourcedetailList(List<SourcedetailEntity> sourcedetailList) {
        this.sourcedetailList = sourcedetailList;
    }
}
