package com.ejianc.business.weigh.wagon.enums;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 自动称重枚举
 */
public enum AutoWeighEnums {

    开启自动称重(0, "开启自动称重"),
    关闭自动称重(1, "关闭自动称重");



    private Integer code;
    private String description;
    private static Map<Integer, AutoWeighEnums> enumMap;

    AutoWeighEnums(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(AutoWeighEnums.class).stream().collect(Collectors.toMap(AutoWeighEnums::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static AutoWeighEnums getEnumByCode(Integer code) {
        return enumMap.get(code);
    }
}
