package com.ejianc.business.weigh.weighbill.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 磅单实体
 * 
 * @author generator
 * 
 */
@ApiModel("磅单实体")
public class PushWeighbillVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("榜单编号")
    private String weightCode;
    @ApiModelProperty("车牌号")
    @NotEmpty
    private String plateNumber;
    @ApiModelProperty("项目")
    private Long projectId;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("")
    private String projectName;
    @ApiModelProperty("项目部id")
    private Long orgId;
    @ApiModelProperty("项目部编码")
    private String orgCode;
    @ApiModelProperty("")
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    private Long parentOrgId;
    @ApiModelProperty("项目部编码")
    private String parentOrgCode;
    @ApiModelProperty("项目部名称")
    private String parentOrgName;
    @ApiModelProperty("合同主键")
    private Long contractId;
    @ApiModelProperty("合同名称")
    private String contractName;
    @ApiModelProperty("合同编号")
    private String contractCode;
    @ApiModelProperty("供应商")
    private Long supplierId;
    @ApiModelProperty("供应商名称")
    private String supplierName;
    @ApiModelProperty("物资类别")
    private Long materialTypeId;
    @ApiModelProperty("物资类别名称")
    private String materialTypeName;
    @ApiModelProperty("物资主键")
    private Long materialId;
    @ApiModelProperty("物资名称")
    private String materialName;
    @ApiModelProperty("物资编码")
    private String materialCode;
    @ApiModelProperty("规格型号")
    private String spec;
    @ApiModelProperty("单位")
    private String unit;
    @ApiModelProperty("单位id")
    private Long unitId;
    @ApiModelProperty("经办人")
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    private String employeeName;
    @ApiModelProperty("毛重")
    @DecimalMin("0")
    private BigDecimal grossWeight;
    @ApiModelProperty("皮重")
    @DecimalMin("0")
    private BigDecimal tareWeight;
    @ApiModelProperty("净重")
    @DecimalMin("0")
    private BigDecimal netWeight;
    @ApiModelProperty("重量单位")
    @NotEmpty
    private String weightUnit;
    @ApiModelProperty("毛重时间")
    @NotEmpty
    private Long grossTime;
    @ApiModelProperty("皮重时间")
    @NotEmpty
    private Long tareTime;
    @ApiModelProperty("换算系数")
    private BigDecimal coefficient;
    @ApiModelProperty("换算后净重")
    private BigDecimal netWeightCoefficient;
    @ApiModelProperty("验收单主键")
    private Long checkId;
    @ApiModelProperty("验收单明细主键")
    private Long checkDetailId;
    @ApiModelProperty("验收状态，0-未验收,1-已验收")
    private Integer checkStatus;
    @ApiModelProperty("发货单主键")
    private Long deliveryId;
    @ApiModelProperty("发货单编号")
    private String deliveryCode;
    @ApiModelProperty("发货单明细主键")
    private Long deliveryDetailId;
    @ApiModelProperty("来源系统")
    @NotEmpty
    private String sourceSystem;
    @ApiModelProperty("磅单3方id")
    @NotEmpty
    private String pmId;
    @ApiModelProperty("备注")
    private String memo;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("磅单日期")
    private Date weightDate;
    @ApiModelProperty("来源称重系统称重结果ID")
    @NotEmpty
    private String thirdWeighId;
    @ApiModelProperty("项目同步编码")
    private String syncCode;


    List<WeighbillImgsVO> weighImgs = new ArrayList<>();


    public List<WeighbillImgsVO> getWeighImgs() {
        return weighImgs;
    }

    public void setWeighImgs(List<WeighbillImgsVO> weighImgs) {
        this.weighImgs = weighImgs;
    }

    public String getSyncCode() {
        return syncCode;
    }

    public void setSyncCode(String syncCode) {
        this.syncCode = syncCode;
    }

    /**
     * 榜单编号
     */
    public String getWeightCode() {
        return weightCode;
    }

    public void setWeightCode(String weightCode) {
        this.weightCode = weightCode;
    }

    public String getPmId() {
        return pmId;
    }

    public void setPmId(String pmId) {
        this.pmId = pmId;
    }

    /**
     * 车牌号
     */
    public String getPlateNumber() {
        return plateNumber;
    }

    /**
     * 车牌号
     */
    public void setPlateNumber(String plateNumber) {
        this.plateNumber = plateNumber;
    }
    /**
     * 项目
     */
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目部id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 项目部id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 项目部编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 项目部编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部上级组织Id
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 项目部上级组织Id
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 项目部编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 物资类别
     */
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    /**
     * 物资类别
     */
    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    /**
     * 物资类别名称
     */
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    /**
     * 物资类别名称
     */
    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    /**
     * 物资主键
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资主键
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    /**
     * 物资编码
     */
    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 单位id
     */
    public Long getUnitId() {
        return unitId;
    }

    /**
     * 单位id
     */
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    /**
     * 经办人
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 毛重
     */
    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    /**
     * 毛重
     */
    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }
    /**
     * 皮重
     */
    public BigDecimal getTareWeight() {
        return tareWeight;
    }

    /**
     * 皮重
     */
    public void setTareWeight(BigDecimal tareWeight) {
        this.tareWeight = tareWeight;
    }
    /**
     * 净重
     */
    public BigDecimal getNetWeight() {
        return netWeight;
    }

    /**
     * 净重
     */
    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }
    /**
     * 重量单位
     */
    public String getWeightUnit() {
        return weightUnit;
    }

    /**
     * 重量单位
     */
    public void setWeightUnit(String weightUnit) {
        this.weightUnit = weightUnit;
    }

    public Long getGrossTime() {
        return grossTime;
    }

    public void setGrossTime(Long grossTime) {
        this.grossTime = grossTime;
    }

    public Long getTareTime() {
        return tareTime;
    }

    public void setTareTime(Long tareTime) {
        this.tareTime = tareTime;
    }

    /**
     * 换算系数
     */
    public BigDecimal getCoefficient() {
        return coefficient;
    }

    /**
     * 换算系数
     */
    public void setCoefficient(BigDecimal coefficient) {
        this.coefficient = coefficient;
    }
    /**
     * 换算后净重
     */
    public BigDecimal getNetWeightCoefficient() {
        return netWeightCoefficient;
    }

    /**
     * 换算后净重
     */
    public void setNetWeightCoefficient(BigDecimal netWeightCoefficient) {
        this.netWeightCoefficient = netWeightCoefficient;
    }
    /**
     * 验收单主键
     */
    public Long getCheckId() {
        return checkId;
    }

    /**
     * 验收单主键
     */
    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }
    /**
     * 验收单明细主键
     */
    public Long getCheckDetailId() {
        return checkDetailId;
    }

    /**
     * 验收单明细主键
     */
    public void setCheckDetailId(Long checkDetailId) {
        this.checkDetailId = checkDetailId;
    }
    /**
     * 验收状态，0-未验收,1-已验收
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * 验收状态，0-未验收,1-已验收
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }
    /**
     * 发货单主键
     */
    public Long getDeliveryId() {
        return deliveryId;
    }

    /**
     * 发货单主键
     */
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    /**
     * 发货单编号
     */
    public String getDeliveryCode() {
        return deliveryCode;
    }

    /**
     * 发货单编号
     */
    public void setDeliveryCode(String deliveryCode) {
        this.deliveryCode = deliveryCode;
    }
    /**
     * 发货单明细主键
     */
    public Long getDeliveryDetailId() {
        return deliveryDetailId;
    }

    /**
     * 发货单明细主键
     */
    public void setDeliveryDetailId(Long deliveryDetailId) {
        this.deliveryDetailId = deliveryDetailId;
    }
    /**
     * 来源系统
     */
    public String getSourceSystem() {
        return sourceSystem;
    }

    /**
     * 来源系统
     */
    public void setSourceSystem(String sourceSystem) {
        this.sourceSystem = sourceSystem;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 磅单日期
     */
    public Date getWeightDate() {
        return weightDate;
    }

    /**
     * 磅单日期
     */
    public void setWeightDate(Date weightDate) {
        this.weightDate = weightDate;
    }
    /**
     * 来源称重系统称重结果ID
     */
    public String getThirdWeighId() {
        return thirdWeighId;
    }

    /**
     * 来源称重系统称重结果ID
     */
    public void setThirdWeighId(String thirdWeighId) {
        this.thirdWeighId = thirdWeighId;
    }
    
}
