/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.weigh.weighbill.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.weigh.weighbill.bean.WeighbillEntity;
import com.ejianc.business.weigh.weighbill.bean.WeighbillImgEntity;
import com.ejianc.business.weigh.weighbill.mapper.WeighbillMapper;
import com.ejianc.business.weigh.weighbill.service.IWeighbillImgService;
import com.ejianc.business.weigh.weighbill.service.IWeighbillService;
import com.ejianc.business.weigh.weighbill.vo.DelWeighbillVO;
import com.ejianc.business.weigh.weighbill.vo.PushWeighbillVO;
import com.ejianc.business.wzxt.api.IOrderApi;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.UploadFileForNetParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="weighbillService")
public class WeighbillServiceImpl
extends BaseServiceImpl<WeighbillMapper, WeighbillEntity>
implements IWeighbillService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "BDCODE";
    private static final String BILL_TYPE = "EJCBT202308000001";
    private final String[] ALLOW_WEIGH_UNIT = new String[]{"\u5343\u514b", "\u516c\u65a4", "KG", "kg", "Kg", "T", "t", "\u5428"};
    private static final String PZ_SOURCETYPE = "pz_image";
    private static final String MZ_SOURCETYPE = "mz_image";
    @Autowired
    private IOrderApi orderApi;
    @Autowired
    private IWeighbillImgService weighbillImgService;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public CommonResponse<String> saveWeigh(PushWeighbillVO weighVO) {
        HashSet<String> set;
        long startTime1 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u4e09\u65b9\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)weighVO));
        String sourceId = weighVO.getPmId();
        String[] ids = sourceId.split("&");
        String type = "";
        String detailId = "";
        String wlId = "";
        if (!"".equals(ids) && ids.length > 0) {
            type = ids[0];
            detailId = ids[1];
            if (ids.length > 2) {
                wlId = ids[3];
            }
        }
        if (!(set = new HashSet<String>(Arrays.asList(this.ALLOW_WEIGH_UNIT))).contains(weighVO.getWeightUnit())) {
            return CommonResponse.error((String)"\u91cd\u91cf\u5355\u4f4d\u4e0d\u5408\u6cd5!");
        }
        OrderVO orderVO = new OrderVO();
        if ("CL".equals(type)) {
            this.logger.info("\u67e5\u8be2\u8ba2\u5355\uff0c\u53c2\u6570\uff1a{}", (Object)detailId);
            CommonResponse commonResponse = this.orderApi.queryOrderByDetailId(Long.valueOf(detailId));
            if (!commonResponse.isSuccess()) {
                this.logger.info("\u67e5\u8be2\u8ba2\u5355\uff0c\u8fd4\u56de\uff1a{}", (Object)commonResponse.getMsg());
                return CommonResponse.error((String)"PM\u67e5\u8be2\u6570\u636e\u5f02\u5e38,\u6570\u636e\u63a8\u9001\u5931\u8d25!");
            }
            orderVO = (OrderVO)commonResponse.getData();
        }
        long endTime1 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u4e00\u4e2a\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime1 - startTime1) + "ms");
        if (null == orderVO || null == orderVO.getPurchaseOrderDetail() || orderVO.getPurchaseOrderDetail().size() <= 0) {
            return CommonResponse.error((String)"PM\u7cfb\u7edf\u672a\u67e5\u8be2\u5230\u6750\u6599\u4fe1\u606f,\u8bf7\u786e\u8ba4\u6570\u636e\u53c2\u6570\u5408\u6cd5\u6027!");
        }
        WeighbillEntity weighEntityDB = (WeighbillEntity)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"third_weigh_id", (Object)weighVO.getThirdWeighId())).eq((Object)"source_system", (Object)weighVO.getSourceSystem())));
        if (null != weighEntityDB) {
            if (null != weighEntityDB.getCheckId()) {
                return CommonResponse.error((String)"\u8be5\u6570\u636ePM\u7cfb\u7edf\u5df2\u88ab\u9a8c\u6536,\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c!");
            }
            super.removeById((Serializable)weighEntityDB.getId());
        }
        long endTime2 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u4e8c\u4e2a\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime2 - endTime1) + "ms");
        WeighbillEntity weighEntity = (WeighbillEntity)((Object)BeanMapper.map((Object)weighVO, WeighbillEntity.class));
        if (StringUtils.isEmpty((CharSequence)weighVO.getWeightCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)weighVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                weighEntity.setWeightCode((String)billCode.getData());
            } else {
                this.logger.info("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                return CommonResponse.error((String)"PM\u751f\u6210\u78c5\u5355\u7f16\u53f7\u5f02\u5e38,\u6570\u636e\u63a8\u9001\u5931\u8d25!");
            }
        }
        weighEntity = this.changeVo(weighEntity, orderVO, weighVO);
        super.saveOrUpdate((Object)weighEntity, false);
        weighVO.setId(weighEntity.getId());
        long endTime3 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u4e09\u4e2a\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime3 - endTime2) + "ms");
        this.uploadImg(weighVO);
        long endTime4 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u56db\u4e2a\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime4 - endTime3) + "ms");
        this.uploadDetailImg(weighVO);
        long endTime5 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u4e94\u4e2a\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime5 - endTime4) + "ms");
        this.logger.info("\u603b\u7684\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime5 - startTime1) + "ms");
        return CommonResponse.success((String)"\u6570\u636e\u63a8\u9001\u6210\u529f");
    }

    @Override
    public CommonResponse<String> deleteWeigh(DelWeighbillVO weighVO) {
        this.logger.info("\u7b2c\u4e09\u65b9\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)weighVO));
        WeighbillEntity weighEntity = (WeighbillEntity)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"third_weigh_id", (Object)weighVO.getThirdWeighId())).eq((Object)"source_system", (Object)weighVO.getSourceSystem())));
        if (null == weighEntity) {
            return CommonResponse.error((String)"\u8be5\u6570\u636e\u5728PM\u7cfb\u7edf\u672a\u88ab\u67e5\u8be2\u5230,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        if (null != weighEntity && null != weighEntity.getCheckId()) {
            return CommonResponse.error((String)"\u8be5\u6570\u636ePM\u7cfb\u7edf\u5df2\u88ab\u9a8c\u6536,\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c!");
        }
        super.removeById((Serializable)weighEntity.getId());
        return CommonResponse.success((String)"\u6570\u636e\u5220\u9664\u6210\u529f");
    }

    @Override
    public CommonResponse<String> saveWeighImgs(PushWeighbillVO weighVO) {
        long startTime1 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u4e09\u65b9\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)weighVO));
        WeighbillEntity weighEntity = (WeighbillEntity)((Object)super.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"third_weigh_id", (Object)weighVO.getThirdWeighId())).eq((Object)"source_system", (Object)weighVO.getSourceSystem())));
        this.weighbillImgService.remove((Wrapper)new QueryWrapper().eq((Object)"weight_id", (Object)weighEntity.getId()));
        long endTime1 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u4e00\u4e2a\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime1 - startTime1) + "ms");
        weighVO.setId(weighEntity.getId());
        weighVO.setId(weighEntity.getId());
        this.uploadImg(weighVO);
        long endTime2 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u4e8c\u4e2a\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime2 - endTime1) + "ms");
        this.uploadDetailImg(weighVO);
        long endTime3 = System.currentTimeMillis();
        this.logger.info("\u7b2c\u4e09\u4e2a\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime3 - endTime2) + "ms");
        this.logger.info("\u7a0b\u5e8f\u603b\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTime3 - startTime1) + "ms");
        return CommonResponse.success((String)"\u540c\u6b65\u78c5\u5355\u56fe\u7247\u6210\u529f");
    }

    public WeighbillEntity changeVo(WeighbillEntity weighEntity, OrderVO orderVO, PushWeighbillVO weighVO) {
        weighEntity.setDeliveryCode(orderVO.getBillCode());
        weighEntity.setProjectId(orderVO.getProjectId());
        weighEntity.setProjectName(orderVO.getProjectName());
        weighEntity.setOrgId(orderVO.getOrgId());
        weighEntity.setOrgName(orderVO.getOrgName());
        weighEntity.setContractName(orderVO.getContractName());
        weighEntity.setSupplierId(orderVO.getSupplierId());
        weighEntity.setSupplierName(orderVO.getSupplierName());
        List orderDetailList = orderVO.getPurchaseOrderDetail();
        OrderDetailVO orderDetailVO = (OrderDetailVO)orderDetailList.get(0);
        weighEntity.setDeliveryId(orderDetailVO.getOrderId());
        weighEntity.setDeliveryDetailId(orderDetailVO.getId());
        weighEntity.setMaterialTypeId(orderDetailVO.getMaterialTypeId());
        weighEntity.setMaterialTypeName(orderDetailVO.getMaterialTypeName());
        weighEntity.setMaterialId(orderDetailVO.getMaterialId());
        weighEntity.setMaterialCode(orderDetailVO.getMaterialCode());
        weighEntity.setMaterialName(orderDetailVO.getMaterialName());
        weighEntity.setSpec(orderDetailVO.getSpec());
        weighEntity.setUnit(orderDetailVO.getUnit());
        weighEntity.setWeightDate(new Date());
        weighEntity.setCheckStatus(0);
        weighEntity.setGrossTime(new Date(weighVO.getGrossTime()));
        weighEntity.setTareTime(new Date(weighVO.getTareTime()));
        return weighEntity;
    }

    public String uploadImg(PushWeighbillVO weighbillVO) {
        List imgVOList = weighbillVO.getWeighImgs();
        if (CollectionUtils.isNotEmpty((Collection)imgVOList)) {
            long endTimeImag;
            AttachmentRequestVO attachmentVO;
            long startTimeImag;
            ArrayList mzListBase64 = new ArrayList();
            ArrayList mzList = new ArrayList();
            ArrayList pzListBase64 = new ArrayList();
            ArrayList pzList = new ArrayList();
            imgVOList.forEach(e -> {
                if (1 == e.getImageType()) {
                    if (StringUtils.isNotEmpty((CharSequence)e.getImageBase64())) {
                        mzListBase64.add(e.getImageBase64());
                    } else if (StringUtils.isNotEmpty((CharSequence)e.getImagePath())) {
                        mzList.add(e.getImagePath());
                    }
                } else if (2 == e.getImageType()) {
                    if (StringUtils.isNotEmpty((CharSequence)e.getImageBase64())) {
                        pzListBase64.add(e.getImageBase64());
                    } else if (StringUtils.isNotEmpty((CharSequence)e.getImagePath())) {
                        pzList.add(e.getImagePath());
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(mzListBase64)) {
                startTimeImag = System.currentTimeMillis();
                attachmentVO = new AttachmentRequestVO();
                attachmentVO.setBillType(BILL_TYPE);
                attachmentVO.setSourceId(weighbillVO.getId().toString());
                attachmentVO.setSourceType(MZ_SOURCETYPE);
                attachmentVO.setHandleImg(Boolean.valueOf(false));
                attachmentVO.setClearBeforeSave(Boolean.valueOf(false));
                attachmentVO.setFileList(mzListBase64);
                this.attachmentApi.uploadForBase64(attachmentVO);
                endTimeImag = System.currentTimeMillis();
                this.logger.info("\u4e0a\u4f20\u4e00\u4e2aMZ\u56fe\u7247\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTimeImag - startTimeImag) + "ms");
            }
            if (CollectionUtils.isNotEmpty(pzListBase64)) {
                startTimeImag = System.currentTimeMillis();
                attachmentVO = new AttachmentRequestVO();
                attachmentVO.setBillType(BILL_TYPE);
                attachmentVO.setSourceId(weighbillVO.getId().toString());
                attachmentVO.setSourceType(PZ_SOURCETYPE);
                attachmentVO.setHandleImg(Boolean.valueOf(false));
                attachmentVO.setClearBeforeSave(Boolean.valueOf(false));
                attachmentVO.setFileList(pzListBase64);
                this.attachmentApi.uploadForBase64(attachmentVO);
                endTimeImag = System.currentTimeMillis();
                this.logger.info("\u4e0a\u4f20\u4e00\u4e2aPZ\u56fe\u7247\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTimeImag - startTimeImag) + "ms");
            }
            if (CollectionUtils.isNotEmpty(mzList)) {
                startTimeImag = System.currentTimeMillis();
                UploadFileForNetParam param = new UploadFileForNetParam();
                param.setTenantId(Long.valueOf(999999L));
                param.setBillType(BILL_TYPE);
                param.setSourceId(weighbillVO.getId());
                param.setSourceType(MZ_SOURCETYPE);
                param.setFilePathList(mzList);
                CommonResponse mzRes = this.attachmentApi.uploadFileFormNet(param);
                long endTimeImag2 = System.currentTimeMillis();
                this.logger.info("\u4e0a\u4f20MZ\u56fe\u7247\u8fd0\u884c\u65f6\u95f4\u4e3a\uff1a" + (endTimeImag2 - startTimeImag) + "ms");
                this.logger.info("MZ\u8fd4\u56de\u7ed3\u679c\uff1a" + (String)mzRes.getData());
            }
            if (CollectionUtils.isNotEmpty(pzList)) {
                UploadFileForNetParam param = new UploadFileForNetParam();
                param.setTenantId(Long.valueOf(999999L));
                param.setBillType(BILL_TYPE);
                param.setSourceId(weighbillVO.getId());
                param.setSourceType(PZ_SOURCETYPE);
                param.setFilePathList(pzList);
                CommonResponse pzRes = this.attachmentApi.uploadFileFormNet(param);
                this.logger.info("PZ\u8fd4\u56de\u7ed3\u679c\uff1a" + (String)pzRes.getData());
            }
        }
        return "";
    }

    public String uploadDetailImg(PushWeighbillVO weighbillVO) {
        List imgVOList = weighbillVO.getWeighImgs();
        ArrayList imgEntities = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)imgVOList)) {
            imgVOList.forEach(e -> {
                WeighbillImgEntity weighbillImgEntity = (WeighbillImgEntity)((Object)((Object)BeanMapper.map((Object)e, WeighbillImgEntity.class)));
                weighbillImgEntity.setThirdWeighId(weighbillVO.getThirdWeighId());
                weighbillImgEntity.setSourceSystem(weighbillVO.getSourceSystem());
                weighbillImgEntity.setWeightId(weighbillVO.getId());
                imgEntities.add(weighbillImgEntity);
            });
            this.weighbillImgService.saveOrUpdateBatch(imgEntities);
        }
        return "";
    }
}

