package com.ejianc.business.progress.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.progress.utils.TreeNodeBUtil;
import com.ejianc.business.progress.vo.WorkItemVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.progress.mapper.WorkItemMapper;
import com.ejianc.business.progress.bean.WorkItemEntity;
import com.ejianc.business.progress.service.IWorkItemService;

import java.util.Collections;
import java.util.List;

/**
 * 工作项表(子表)
 * 
 * @author generator
 * 
 */
@Service("workItemService")
public class WorkItemServiceImpl extends BaseServiceImpl<WorkItemMapper, WorkItemEntity> implements IWorkItemService{


    @Autowired
    private WorkItemMapper workItemMapper;
    @Override
    public List<WorkItemVO> detailRef(Long stageId) {
        QueryWrapper<WorkItemEntity> wrapper=new QueryWrapper<>();
        wrapper.eq("stage_id",stageId);
        List<WorkItemEntity>entities=baseMapper.selectList(wrapper);
        if (entities!=null && entities.size()>0) {
            for (WorkItemEntity workItemEntity : entities) {
                workItemEntity.setTid(workItemEntity.getId().toString());
                workItemEntity.setTpid(workItemEntity.getParentId() != null && workItemEntity.getParentId() > 0 ? workItemEntity.getParentId().toString() : "");
            }
        }
            List<WorkItemVO>detailVos= BeanMapper.mapList(entities,WorkItemVO.class);

        return TreeNodeBUtil.buildTree(detailVos);
    }

    @Override
    public CommonResponse<WorkItemVO> saveOrUpdate(WorkItemVO workItemVO) {

        Long tenantId= InvocationInfoProxy.getTenantid();

        LambdaQueryWrapper<WorkItemEntity>lambdaQueryWrapper= Wrappers.<WorkItemEntity>lambdaQuery();
        lambdaQueryWrapper.eq(WorkItemEntity::getTenantId,tenantId);
        lambdaQueryWrapper.eq(WorkItemEntity::getStageId,workItemVO.getStageId());
        if (workItemVO.getId()!=null && workItemVO.getId()>0){
            lambdaQueryWrapper.ne(WorkItemEntity::getId,workItemVO.getId());
        }

        return CommonResponse.success("保存成功");
    }

    @Override
    public List<WorkItemVO> queryStageDetail(Long stageId) {

        List<WorkItemVO> workItemVOS = baseMapper.queryStageDetail(stageId);

        return workItemVOS;
    }

    @Override
    public List<WorkItemVO> queryListByPid(Long id) {
        QueryWrapper<WorkItemEntity>wrapper=new QueryWrapper<>();
        wrapper.eq("parent_id",id);
        List<WorkItemEntity>entities=workItemMapper.selectList(wrapper);
        if (entities!=null){
            return BeanMapper.mapList(entities,WorkItemVO.class);
        }
        return null;
    }
}
