/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbusiness.bean.OrderEntity;
import com.ejianc.business.supbusiness.common.util.BillShareLInkCheckHelper;
import com.ejianc.business.supbusiness.service.IOrderService;
import com.ejianc.business.supbusiness.vo.OrderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"order"})
public class OrderController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private BillShareLInkCheckHelper billShareLInkCheckHelper;
    @Autowired
    private IOrderService service;

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> saveOrUpdate(HttpServletRequest request, @RequestParam(value="file", required=false) MultipartFile file) {
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)this.service.saveOrder(request, file));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(@RequestParam Long id) {
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.service.queryOrderDetail(id));
    }

    @ApiOperation(value="\u534f\u540c\u5206\u4eab\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/detailBySourceId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> detailBySourceId(@RequestParam(value="id") String sourceId, @RequestParam(value="tl") String timeout, @RequestParam String weakFlag, @RequestParam String supplierTenant, @RequestParam String secret) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById((Serializable)((Object)sourceId)));
        if (null == orderEntity) {
            return CommonResponse.error((String)"\u5355\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        String checkMsg = this.billShareLInkCheckHelper.isShareLinkValid(timeout, sourceId, orderEntity.getSupplierId().toString(), weakFlag, secret, supplierTenant);
        if (StringUtils.isNotBlank((CharSequence)checkMsg)) {
            return CommonResponse.error((String)checkMsg);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OrderVO orderVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryAllList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.service.queryAllList(param));
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.service.queryOrderWaitList(param));
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryOrderDeliveredList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryOrderDeliveredList(@RequestBody QueryParam param) {
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.service.queryOrderDeliveredList(param));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialOrder-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refMaterialOrderData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> refMaterialOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OrderVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5168\u90e8\u63a5\u6536\u3001\u90e8\u5206\u63a5\u6536\u3001\u4e0d\u4e88\u63a5\u6536\u63a5\u53e3")
    @RequestMapping(value={"/saveOrderDelivered"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OrderVO> saveOrderDelivered(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OrderVO saveOrUpdateVO) {
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01", (Object)this.service.saveOrderDelivered(saveOrUpdateVO));
    }

    @ApiOperation(value="\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/deleteOrder"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> deleteOrder(@RequestBody OrderVO vo) {
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01", (Object)this.service.deleteOrder(vo));
    }

    @ApiOperation(value="\u5173\u95ed\u8ba2\u5355")
    @RequestMapping(value={"/updateOrderCloseFlag"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Boolean> updateOrderCloseFlag(@RequestBody OrderVO vo) {
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01", (Object)this.service.updateOrderCloseFlag(vo));
    }
}

