/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supbusiness.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.supbusiness.bean.DeliveryCarEntity;
import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.mapper.DeliveryCarMapper;
import com.ejianc.business.supbusiness.service.IDeliveryCarService;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.vo.DeliveryCarVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="deliveryCarService")
public class DeliveryCarServiceImpl
extends BaseServiceImpl<DeliveryCarMapper, DeliveryCarEntity>
implements IDeliveryCarService {
    @Autowired
    private IDeliveryService deliveryService;

    @Override
    public DeliveryCarVO saveOrUpdate(DeliveryCarVO deliveryInfoCar) {
        if (null == deliveryInfoCar.getId()) {
            DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.selectById(deliveryInfoCar.getDeliveryId()));
            deliveryInfoCar.setOrgId(delivery.getOrgId());
            deliveryInfoCar.setProjectId(delivery.getProjectId());
            deliveryInfoCar.setProjectName(delivery.getProjectName());
            deliveryInfoCar.setPlatformCode(delivery.getPlatformCode());
            deliveryInfoCar.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        }
        DeliveryCarEntity entity = (DeliveryCarEntity)((Object)BeanMapper.map((Object)((Object)deliveryInfoCar), DeliveryCarEntity.class));
        this.saveOrUpdate((Object)entity, false);
        return (DeliveryCarVO)((Object)BeanMapper.map((Object)((Object)entity), DeliveryCarVO.class));
    }

    @Override
    public List<String> queryNumber(Long pkSupplier, String searchTaxt) {
        LambdaQueryWrapper entityWrapper = new LambdaQueryWrapper();
        entityWrapper.eq(DeliveryCarEntity::getSupplierId, (Object)pkSupplier);
        entityWrapper.like(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchTaxt}), DeliveryCarEntity::getDeliveryCarNumber, (Object)searchTaxt);
        List deliveryInfoCars = this.list((Wrapper)entityWrapper);
        if (CollectionUtils.isNotEmpty((Collection)deliveryInfoCars)) {
            return deliveryInfoCars.stream().map(DeliveryCarEntity::getDeliveryCarNumber).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<DeliveryCarVO> queryDeliveryInfoCar(Long deliveryId, Long deliveryDetailId) {
        LambdaQueryWrapper entityWrapper = new LambdaQueryWrapper();
        entityWrapper.eq(DeliveryCarEntity::getDeliveryId, (Object)deliveryId);
        entityWrapper.eq(DeliveryCarEntity::getDeliveryDetailId, (Object)deliveryDetailId);
        List list = this.list((Wrapper)entityWrapper);
        return CollectionUtils.isNotEmpty((Collection)list) ? BeanMapper.mapList((Iterable)list, DeliveryCarVO.class) : null;
    }
}

