package com.ejianc.business.supbusiness.controller;

import java.io.Serializable;

import com.ejianc.business.supbusiness.vo.DeliveryCarVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.supbusiness.bean.WeighApplyEntity;
import com.ejianc.business.supbusiness.service.IWeighApplyService;
import com.ejianc.business.supbusiness.vo.WeighApplyVO;

/**
 * 过磅申请
 *
 * @author generator
 */
@Controller
@RequestMapping("weighApply")
public class WeighApplyController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWeighApplyService weighApplyService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WeighApplyVO> saveOrUpdate(@RequestBody WeighApplyVO saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", weighApplyService.saveOrUpdate(saveOrUpdateVO));
    }

    //PC端提交推送接口
    @PostMapping(value = "addyzPCWeighApply")
    public CommonResponse<WeighApplyVO> addyzPCWeighApply(@RequestBody DeliveryCarVO deliveryCarVO) {
        return CommonResponse.success("提交单据成功！", weighApplyService.addyzPCWeighApply(deliveryCarVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeighApplyVO> queryDetail(Long id) {
        WeighApplyEntity entity = weighApplyService.selectById(id);
        WeighApplyVO vo = BeanMapper.map(entity, WeighApplyVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WeighApplyVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (WeighApplyVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        weighApplyService.removeByIds(vos.stream().map(WeighApplyVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WeighApplyVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<WeighApplyEntity> page = weighApplyService.queryPage(param, false);
        IPage<WeighApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeighApplyVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 取历史车牌号
     * @param openid
     * @return
     */
    @RequestMapping(value = "/queryCarNumRecord", method = RequestMethod.GET)
    @ResponseBody
    public  CommonResponse<List<String>> queryCarNumRecord(@RequestParam("openid") String openid) {
        return CommonResponse.success("查询历史车牌号数据成功！", weighApplyService.queryCarNumRecord(openid));
    }

    /**
     * 取最近一次申请单
     * @param openid
     * @return
     */
    @RequestMapping(value = "/queryLastDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WeighApplyVO> queryLastDetail(@RequestParam("openid") String openid) {
        return CommonResponse.success("查询取最近一次申请单成功！", weighApplyService.queryLastDetail(openid));
    }



    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<WeighApplyEntity> list = weighApplyService.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("WeighApply-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refWeighApplyData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WeighApplyVO>> refWeighApplyData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                 String condition,
                                                                 String searchObject,
                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WeighApplyEntity> page = weighApplyService.queryPage(param, false);
        IPage<WeighApplyVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WeighApplyVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
