package com.ejianc.business.supbusiness.enums;

/**
 * 订单送货状态枚举
 */
public enum OrderDeliverStateEnum {

    /** 代送货 */
    WAIT_DELIVERED(0,"待送货"),
    /** 部分送货 */
    PART_DELIVERED(1,"部分送货"),
    /** 已送货 */
    FULL_DELIVERED(2,"已送货");

    private Integer code;

    private String description;

    OrderDeliverStateEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    };


    /**
     * 获取状态
     * @return 状态
     */
    public Integer getCode() {
        return this.code;
    }

    /**
     * 获取状态注释
     * @return 状态注释
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * 根据状态获取状态枚举
     * @param planState 状态
     * @return 状态枚举
     */
    public static OrderDeliverStateEnum getEnumByStateCode(Integer planState) {
        for (OrderDeliverStateEnum enu : OrderDeliverStateEnum.values()) {
            if (enu.getCode().equals(planState)) return enu;
        }
        return null;
    }

    /**
     * 根据状态获取状态注释
     * @param planState 状态
     * @return 状态注释
     */
    public static String getDescriptionByStateCode(Integer planState){
        OrderDeliverStateEnum enu = getEnumByStateCode(planState);
        if (enu != null) return enu.getDescription();
        return null;
    }
}
