package com.ejianc.business.supbusiness.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.supbusiness.bean.OrderDetailEntity;
import com.ejianc.business.supbusiness.vo.OrderDetailVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 消耗材订单明细表
 *
 * @author generator
 *
 */
public interface IOrderDetailService extends IBaseService<OrderDetailEntity> {

    /**
     * 根据订单id删除订单明细（真实删除delete）
     *
     * @param orderId 订单id
     * @return 删除结果
     */
    boolean deleteOrderDetailByOrderId(Long orderId);

    /**
     * 查询材料参照
     *
     * @param pageNumber   当前页
     * @param pageSize     分页大小
     * @param condition    查询参数
     * @param searchObject 模糊查询
     * @param searchText   模糊查询
     * @return 查询结果
     */
    IPage<OrderDetailVO> refMaterialOrderDetailData(Integer pageNumber, Integer pageSize,
                                                    String condition,
                                                    String searchObject,
                                                    String searchText);
}
