package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.supbusiness.bean.CheckDetailEntity;
import com.ejianc.business.supbusiness.bean.CheckEntity;
import com.ejianc.business.supbusiness.constant.InteractiveConstants;
import com.ejianc.business.supbusiness.enums.CheckSupplierSignStatusEnum;
import com.ejianc.business.supbusiness.mapper.CheckMapper;
import com.ejianc.business.supbusiness.service.ICheckService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.vo.CheckDbVO;
import com.ejianc.business.supbusiness.vo.CheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材验收单
 *
 * @author generator
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /** 单据类型 */
    private static final String billType = "EJCBT202408000005";

    private static final String checkFileSourceType = "materialCheck";
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IAttachmentApi attachmentApi;


    /**
     * 保存验收单
     *
     * @param request 请求信息
     * @return 保存结果
     */
    @Override
    public boolean saveCheck(HttpServletRequest request) {
        logger.info("进入验收单保存接口>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        logger.info("接收到数据transData：{}，nameSourceTypeMapping：{}", transData, nameSourceTypeMapping);
        // 转换
        CheckDbVO tbVO = JSONObject.parseObject(transData, CheckDbVO.class);

        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, tbVO.getSourceId()));
        List<CheckEntity> checkEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(checkEntityList)) {
            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(checkEntityList));
//            throw new BusinessException("验收单已在存在！");
        }
        CheckEntity saveEntity = BeanMapper.map(tbVO, CheckEntity.class);
        saveEntity.setCheckDetailList(BeanMapper.mapList(tbVO.getCheckDetailList(),
                CheckDetailEntity.class));
        saveEntity.setSupplierSignStatus(CheckSupplierSignStatusEnum.未签字.getCode());
        //保存单据中附件并获取到上传后附件的Id
        Map<String, List<Long>> attachIdsMap = FileUtil.getInstance()
                .handleReqFile((MultipartHttpServletRequest) request, mp, billType, authority, null);
        List<Long> attchIdsList = new ArrayList<>();
        for (List<Long> attachIds : attachIdsMap.values()) {
            if (CollectionUtils.isNotEmpty(attachIds)) {
                attchIdsList.addAll(attachIds);
            }
        }
        saveEntity.setAttachIds(attchIdsList);
        boolean flag = super.saveOrUpdate(saveEntity, false);
        logger.info("保存成功，验收单保存结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    /**
     * 删除验收单
     *
     * @param vo 需要删除的验收单
     * @return 删除结果
     */
    @Override
    public boolean deleteCheck(CheckVO vo) {
        logger.info("进入验收单撤回接口>>>>>>>>>>>>>>>>>>>>>>>>");
        logger.info("接收到数据：{}", JSONObject.toJSONString(vo));
        if (vo.getSourceId() == null) {
            throw new BusinessException("验收单不存在");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, vo.getSourceId()));
        List<CheckEntity> checkEntityList = super.queryList(queryParam,false);
        if (CollectionUtils.isEmpty(checkEntityList)) {
            throw new BusinessException("验收单不存在");
        }
        CheckEntity checkEntity = checkEntityList.get(0);
        if (vo.getSystemId() == null || !vo.getSystemId().equals(checkEntity.getSystemId())) {
            throw new BusinessException("系统来源不匹配");
        }
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(checkEntity.getId(), billType, null, null);
        // 查询成功并有相应的文件
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
                    .collect(Collectors.joining(","));
            attachmentApi.delete(ids);
        }
        boolean flag = super.removeById(checkEntity.getId(), false);
        logger.info("验收单撤回成功<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return flag;
    }

    /**
     * 验收单签字
     *
     * @param checkVO 需要签字的验收单
     * @return 签字结果
     */
    @Override
    public CheckVO saveSupplierSign(CheckVO checkVO) {
        logger.info("开始通知施工方验收单信息>>>>>>>>>>>>>>>>>>>");
        CheckEntity saveEntity = super.selectById(checkVO.getId());
        saveEntity.setSupplierSignStatus(CheckSupplierSignStatusEnum.已签字.getCode());
        saveEntity.setSupOperateTime(new Date());
        saveEntity.setSupOperatorName(checkVO.getSupOperatorName());
        saveEntity.setSupOperatorPhone(checkVO.getSupOperatorPhone());
        saveEntity.setSupOperatorUserCode(checkVO.getSupOperatorUserCode());
        Map<String, String> paramMap = new HashMap<>();
//        MaterialCheckTbVO tbVO = BeanMapper.map(saveEntity, MaterialCheckTbVO.class);
//        tbVO.setCheckDetailList(BeanMapper.mapList(saveEntity.getMaterialCheckDetailList(), MaterialCheckDetailTbVO.class));
//        paramMap.put("transData", JSONObject.toJSONString(tbVO));

        paramMap.put("billId", CommonUtils.createString(saveEntity.getSourceId()));
        paramMap.put("supOperatorName", CommonUtils.createString(saveEntity.getSupOperatorName()));
        paramMap.put("supOperatorPhone", CommonUtils.createString(saveEntity.getSupOperatorPhone()));
        paramMap.put("supOperatorUserCode", CommonUtils.createString(saveEntity.getSupOperatorUserCode()));
        paramMap.put("supOperateTime", CommonUtils.createString(saveEntity.getSupOperateTime().getTime()));

        // 查询文件信息
        //查询单据附件信息并下载
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(saveEntity.getId(), billType, checkFileSourceType, null);
        if (!fileResp.isSuccess()) {
            throw new BusinessException("查询文件信息失败！");
        }
        Map<String, Map<String, InputStream>> files = new HashMap<>();
        List<AttachmentVO> fileList = fileResp.getData();

        //Map<fileName, fileSourceType>
        Map<String, String> fileSourceTypeMap = new HashMap<>();
        List<Long> fileIds = new ArrayList<>();

        //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
        for (AttachmentVO attach : fileList) {
            fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
            fileIds.add(attach.getId());
        }
        paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
        //当前单据携带有附件信息
        if (CollectionUtils.isNotEmpty(fileList)) {
            Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
            fileMap.keySet().stream().forEach(fileKey -> {
                Map<String, InputStream> file = new HashMap<>(1);
                file.put(fileKey, fileMap.get(fileKey));
                files.put(fileKey, file);
            });
        }
//        String url = pushMaterialCheck;
        String url = InteractiveConstants.PUSH_MATERIAL_CHECK;
        String systemId = saveEntity.getSystemId();
        logger.info("发送参数===url:{},paramMap:[{}],systemId:{},files:{}", url, paramMap, systemId, files);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataAndFilesWithThirdSystem(url, paramMap, systemId, files);
        CommonUtils.checkCommonResponse(commonResponse, logger);
        super.saveOrUpdate(saveEntity, false);
        logger.info("通知施工方验收单信息结束<<<<<<<<<<<<<<<<<<<<<<");
        return BeanMapper.map(saveEntity, CheckVO.class);
    }

    /**
     * 根据sourceId查询验收单
     *
     * @param sourceId sourceId
     * @return 验收单明细
     */
    @Override
    public CheckVO queryCheckBySourceId(String sourceId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("sourceId", new Parameter(QueryParam.EQ, sourceId));
        List<CheckEntity> checkEntityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(checkEntityList)) return null;
        CheckEntity checkEntity = super.selectById(checkEntityList.get(0).getId());
        return BeanMapper.map(checkEntity, CheckVO.class);
    }


}
