package com.ejianc.business.supbusiness.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.supbusiness.bean.DeliveryCarEntity;
import com.ejianc.business.supbusiness.bean.DeliveryDetailEntity;
import com.ejianc.business.supbusiness.bean.DeliveryEntity;
import com.ejianc.business.supbusiness.bean.WeighApplyEntity;
import com.ejianc.business.supbusiness.constant.InteractiveConstants;
import com.ejianc.business.supbusiness.mapper.WeighApplyMapper;
import com.ejianc.business.supbusiness.service.IDeliveryCarService;
import com.ejianc.business.supbusiness.service.IDeliveryDetailService;
import com.ejianc.business.supbusiness.service.IDeliveryService;
import com.ejianc.business.supbusiness.service.IWeighApplyService;
import com.ejianc.business.supbusiness.utils.CommonUtils;
import com.ejianc.business.supbusiness.vo.DeliveryCarVO;
import com.ejianc.business.supbusiness.vo.WeighApplyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.Date;
import java.util.List;

/**
 * 过磅申请
 *
 * @author generator
 *
 */
@Service("weighApplyService")
public class WeighApplyServiceImpl extends BaseServiceImpl<WeighApplyMapper, WeighApplyEntity> implements IWeighApplyService{

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private IDeliveryCarService deliveryCarService;

    @Override
    public WeighApplyVO saveOrUpdate(WeighApplyVO saveOrUpdateVO) {
        WeighApplyEntity entity = fullAddData(saveOrUpdateVO);
        entity.setId(IdWorker.getId());
        entity.setApplyDate(new Date());
        entity.setOtherId(entity.getDeliveryId() + "@@" + entity.getDeliveryDetailId() + "@@" + entity.getId() + "@@" + entity.getMaterialId());
        saveOrUpdate(entity);

        logger.info("开始通知施工方过磅申请信息>>>>>>>>>>>>>>>>>>>");
//        String url = pushMaterialDelivery;
        String url = InteractiveConstants.PUSH_WEIGH_APPLY;
        WeighApplyVO tbVO = BeanMapper.map(entity, WeighApplyVO.class);
        String postData = JSONObject.toJSONString(tbVO);
        String systemId = entity.getSystemId();
        logger.info("发送参数===url:{},postData:[{}],systemId:{}", url, postData, systemId);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, logger);
        logger.info("通知施工方发货单信息结束<<<<<<<<<<<<<<<<<<<<");
        return BeanMapper.map(entity, WeighApplyVO.class);
    }

    @Override
    public WeighApplyVO addyzPCWeighApply(DeliveryCarVO deliveryCarVO) {
        //查询单据信息
        WeighApplyEntity entity = fullPcAddData(deliveryCarVO);
        entity.setId(IdWorker.getId());
        entity.setApplyDate(new Date());
        entity.setOtherId(entity.getDeliveryId() + "@@" + entity.getDeliveryDetailId() + "@@" + entity.getId() + "@@" + entity.getMaterialId());
        saveOrUpdate(entity);

        logger.info("开始通知施工方过磅申请信息>>>>>>>>>>>>>>>>>>>");
//        String url = pushMaterialDelivery;
        String url = InteractiveConstants.PUSH_WEIGH_APPLY;
        WeighApplyVO tbVO = BeanMapper.map(entity, WeighApplyVO.class);
        tbVO.setPcCarInfoFlag(true);
        String postData = JSONObject.toJSONString(tbVO);
        String systemId = entity.getSystemId();
        logger.info("发送参数===url:{},postData:[{}],systemId:{}", url, postData, systemId);
        CommonResponse<String> commonResponse = systemDataPushService
                .exchangeDataWithThirdSystem(url, RequestMethod.POST, postData, systemId);
        CommonUtils.checkCommonResponse(commonResponse, logger);
        logger.info("通知施工方发货单信息结束<<<<<<<<<<<<<<<<<<<<");
        //提交成功修改状态
        LambdaUpdateWrapper<DeliveryCarEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(DeliveryCarEntity::getBillState, BillStateEnum.COMMITED_STATE.getBillStateCode());
        updateWrapper.set(DeliveryCarEntity::getWeighApplyId, entity.getId());
        updateWrapper.eq(DeliveryCarEntity::getId, deliveryCarVO.getId());
        deliveryCarService.update(updateWrapper);
        return BeanMapper.map(entity, WeighApplyVO.class);
    }

    @Override
    public List<String> queryCarNumRecord(String openid) {
        return baseMapper.queryCarNumRecord(openid);
    }

    @Override
    public WeighApplyVO queryLastDetail(String openid) {
        LambdaQueryWrapper<WeighApplyEntity> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(WeighApplyEntity::getOpenid, openid);
        queryWrapper.orderByDesc(WeighApplyEntity::getApplyDate);
        queryWrapper.last("limit 1");
        WeighApplyEntity weighApplyEntity = getOne(queryWrapper, false);
        return null != weighApplyEntity ? BeanMapper.map(weighApplyEntity, WeighApplyVO.class) : null;
    }

    //pc端车次信息
    private WeighApplyEntity fullPcAddData(DeliveryCarVO deliveryCarVO){
        WeighApplyEntity entity = new WeighApplyEntity();
        DeliveryEntity delivery = deliveryService.selectById(deliveryCarVO.getDeliveryId());
        BeanUtils.copyProperties(delivery, entity);

        DeliveryCarEntity deliveryInfoCar = deliveryCarService.selectById(deliveryCarVO.getDeliveryDetailId());
        BeanUtils.copyProperties(deliveryInfoCar, entity);
        entity.setMaterialAmount(deliveryInfoCar.getMaterialAmount());
        entity.setCarNumber(deliveryInfoCar.getDeliveryCarNumber());
        entity.setUpdateUserCode(null);
        entity.setUpdateTime(null);
        entity.setSystemId(delivery.getSystemId());
        return entity;
    }

    /**
     * 补全新增数据
     * @param weighApplyVO
     * @return
     */
    private WeighApplyEntity fullAddData(WeighApplyVO weighApplyVO){
        DeliveryEntity delivery = deliveryService.selectById(weighApplyVO.getDeliveryId());

        WeighApplyEntity entity = new WeighApplyEntity();
        BeanUtils.copyProperties(delivery, entity);
        entity.setDeliveryDetailId(weighApplyVO.getDeliveryDetailId());
        entity.setOpenid(weighApplyVO.getOpenid());
        entity.setCarNumber(weighApplyVO.getCarNumber());
        entity.setCarSerial(weighApplyVO.getCarSerial());
        entity.setSystemId(delivery.getSystemId());

        DeliveryDetailEntity deliveryInfo = deliveryDetailService.selectById(entity.getDeliveryDetailId());
        BeanUtils.copyProperties(deliveryInfo, entity);
        entity.setUpdateUserCode(null);
        entity.setUpdateTime(null);
        return entity;
    }
}
