package com.ejianc.business.supbusiness.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 领料单-主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_deliveryrecord")
public class DeliveryrecordEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="approve_time")
    private Date approveTime; // 审批通过日期
    @TableField(value="projectdept_id")
    private Long projectdeptId; // 项目部人员id
    @TableField(value="projectdept")
    private String projectdept; // 项目部人员
    @TableField(value="bills_time")
    private Date billsTime; // 单据日期
    @TableField(value="brands")
    private String brands; // 品牌
    @TableField(value="picking_time")
    private Date pickingTime; // 领料日期
    @TableField(value="pickingUnit_id")
    private Long pickingunitId; // 领料单位id
    @TableField(value="picking_unit")
    private String pickingUnit; // 领料单位
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="change_id")
    private Long changeId; // 变更单据id
    @TableField(value="change_state")
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="agent_id")
    private Long agentId; // 经办人
    @TableField(value="agent_name")
    private String agentName; // 经办人姓名
    @TableField(value="issue_num")
    private String issueNum; // 出库编号
    @TableField(value="receiving_purpose")
    private String receivingPurpose; // 领用用途
    @TableField(value="signature_cust")
    private String signatureCust; // 保管员签字
    @TableField(value="project_material")
    private String projectMaterial; // 项目物资部
    @TableField(value="project_engineer")
    private String projectEngineer; // 项目管理部
    @TableField(value="ministry")
    private String ministry; // 商务部
    @TableField(value="approval_date")
    private Date approvalDate; // 审批日期
    @TableField(value="store_id")
    private Long storeId; // 仓库id
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="delivery_type")
    private Integer deliveryType; // 出库单类型 0-自动出库单 1-手动出库单
    @TableField(value="warehousing_id")
    private Long warehousingId; // 入库单id
    @TableField(value="delivery_types")
    private Integer deliveryTypes; // 出库类型 0-成品出库 1-成品退库 2-直入直出退库  3-废旧物资出库 4-资产出库 5-废旧物资退库 6-资产退库
    @TableField(value="delivery_id")
    private Long deliveryId; // 出库单id
    @TableField(value="not_delivery_quantity")
    private BigDecimal notDeliveryQuantity; // 未出库数量
    @TableField(value="receipt_doc_id")
    private Long receiptDocId; // 入库单id参照使用
    @TableField(value="returned_store_id")
    private Long returnedStoreId; // 退库仓库id
    @TableField(value="returned_store_name")
    private String returnedStoreName; // 退库仓库名称
    @TableField(value="returned_store_date")
    private Date returnedStoreDate; // 退库日期
    @TableField(value="self_state")
    private String selfState; // 是否自施 0-否 1-是
    @TableField(value="apply_unit")
    private String applyUnit; // 供应单位
    @TableField(value="acceptance_type")
    private String acceptanceType; // 验收类型
    @TableField(value="out_mny_tax")
    private BigDecimal outMnyTax; // 出库金额(含税)
    @TableField(value="out_mny")
    private BigDecimal outMny; // 出库金额
    @TableField(value="puin_time")
    private Date puinTime; // 入库日期
    @TableField(value="puin_time_limit")
    private Date puinTimeLimit; // 入库单的入库日期校验用
    @TableField(value="system_id")
    private String systemId; // 来源系统主键
    @TableField(value="source_id")
    private Long sourceId; // 来源订单主键
    @TableField(value="bill_push_flag")
    private String billPushFlag; // 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
    @TableField(value="sup_operator_name")
    private String supOperatorName; // 供方经办人名称
    @TableField(value="sup_operator_phone")
    private String supOperatorPhone; // 供方经办人手机号
    @TableField(value="sup_operator_user_code")
    private String supOperatorUserCode; // 供方经办人账号
    @TableField(value="sup_operate_time")
    private Date supOperateTime; // 供方经办人签字时间

    @TableField(value="sign_status")
    private Integer signStatus; // 分包签字状态, 1-未签字,2-已签字
    @TableField(exist=false)
    @SubEntity(serviceName = "deliveryrecorddetailService", pidName = "mid")//此处有pid="xxx"，默认值pid="pid"
    private List<DeliveryrecorddetailEntity> deliveryrecorddetailEntityList = new ArrayList<>(); // 领料计划-子表
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }
    public Long getProjectdeptId() {
        return projectdeptId;
    }

    public void setProjectdeptId(Long projectdeptId) {
        this.projectdeptId = projectdeptId;
    }
    public String getProjectdept() {
        return projectdept;
    }

    public void setProjectdept(String projectdept) {
        this.projectdept = projectdept;
    }
    public Date getBillsTime() {
        return billsTime;
    }

    public void setBillsTime(Date billsTime) {
        this.billsTime = billsTime;
    }
    public String getBrands() {
        return brands;
    }

    public void setBrands(String brands) {
        this.brands = brands;
    }
    public Date getPickingTime() {
        return pickingTime;
    }

    public void setPickingTime(Date pickingTime) {
        this.pickingTime = pickingTime;
    }
    public Long getPickingunitId() {
        return pickingunitId;
    }

    public void setPickingunitId(Long pickingunitId) {
        this.pickingunitId = pickingunitId;
    }
    public String getPickingUnit() {
        return pickingUnit;
    }

    public void setPickingUnit(String pickingUnit) {
        this.pickingUnit = pickingUnit;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public String getIssueNum() {
        return issueNum;
    }

    public void setIssueNum(String issueNum) {
        this.issueNum = issueNum;
    }
    public String getReceivingPurpose() {
        return receivingPurpose;
    }

    public void setReceivingPurpose(String receivingPurpose) {
        this.receivingPurpose = receivingPurpose;
    }
    public String getSignatureCust() {
        return signatureCust;
    }

    public void setSignatureCust(String signatureCust) {
        this.signatureCust = signatureCust;
    }
    public String getProjectMaterial() {
        return projectMaterial;
    }

    public void setProjectMaterial(String projectMaterial) {
        this.projectMaterial = projectMaterial;
    }
    public String getProjectEngineer() {
        return projectEngineer;
    }

    public void setProjectEngineer(String projectEngineer) {
        this.projectEngineer = projectEngineer;
    }
    public String getMinistry() {
        return ministry;
    }

    public void setMinistry(String ministry) {
        this.ministry = ministry;
    }
    public Date getApprovalDate() {
        return approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }
    public Long getWarehousingId() {
        return warehousingId;
    }

    public void setWarehousingId(Long warehousingId) {
        this.warehousingId = warehousingId;
    }
    public Integer getDeliveryTypes() {
        return deliveryTypes;
    }

    public void setDeliveryTypes(Integer deliveryTypes) {
        this.deliveryTypes = deliveryTypes;
    }
    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public BigDecimal getNotDeliveryQuantity() {
        return notDeliveryQuantity;
    }

    public void setNotDeliveryQuantity(BigDecimal notDeliveryQuantity) {
        this.notDeliveryQuantity = notDeliveryQuantity;
    }
    public Long getReceiptDocId() {
        return receiptDocId;
    }

    public void setReceiptDocId(Long receiptDocId) {
        this.receiptDocId = receiptDocId;
    }
    public Long getReturnedStoreId() {
        return returnedStoreId;
    }

    public void setReturnedStoreId(Long returnedStoreId) {
        this.returnedStoreId = returnedStoreId;
    }
    public String getReturnedStoreName() {
        return returnedStoreName;
    }

    public void setReturnedStoreName(String returnedStoreName) {
        this.returnedStoreName = returnedStoreName;
    }
    public Date getReturnedStoreDate() {
        return returnedStoreDate;
    }

    public void setReturnedStoreDate(Date returnedStoreDate) {
        this.returnedStoreDate = returnedStoreDate;
    }
    public String getSelfState() {
        return selfState;
    }

    public void setSelfState(String selfState) {
        this.selfState = selfState;
    }
    public String getApplyUnit() {
        return applyUnit;
    }

    public void setApplyUnit(String applyUnit) {
        this.applyUnit = applyUnit;
    }
    public String getAcceptanceType() {
        return acceptanceType;
    }

    public void setAcceptanceType(String acceptanceType) {
        this.acceptanceType = acceptanceType;
    }
    public BigDecimal getOutMnyTax() {
        return outMnyTax;
    }

    public void setOutMnyTax(BigDecimal outMnyTax) {
        this.outMnyTax = outMnyTax;
    }
    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }
    public Date getPuinTime() {
        return puinTime;
    }

    public void setPuinTime(Date puinTime) {
        this.puinTime = puinTime;
    }
    public Date getPuinTimeLimit() {
        return puinTimeLimit;
    }

    public void setPuinTimeLimit(Date puinTimeLimit) {
        this.puinTimeLimit = puinTimeLimit;
    }
    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }
    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public List<DeliveryrecorddetailEntity> getDeliveryrecorddetailEntityList() {
        return deliveryrecorddetailEntityList;
    }

    public void setDeliveryrecorddetailEntityList(List<DeliveryrecorddetailEntity> deliveryrecorddetailEntityList) {
        this.deliveryrecorddetailEntityList = deliveryrecorddetailEntityList;
    }
}
