package com.ejianc.business.supbusiness.common.util;

import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.util.DESUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springside.modules.nosql.redis.JedisTemplate;

import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2022/1/20 17:07
 */
@Component
public class BillShareLInkCheckHelper {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private CacheManager cacheManager;

    public String isShareLinkValid(String timeout, String billId, String supplierId, String weakFlag, String secret, String supplierTenant) {
        StringBuffer sp = new StringBuffer();
        sp.append("id=")
                .append(billId)
                .append("&tl=").append(timeout)
                .append("&supplierTenant=").append(supplierTenant)
                .append("&weakFlag=").append(weakFlag)
                .append("&supplierId=").append(supplierId);

        //检测连接是否被篡改
        if(!secret.equals(DESUtils.encrypt(sp.toString()))) {
            logger.info("timeout-{}, billId-{}, supplierId-{}加密后不匹配密钥secret-{}", timeout,
                    billId, supplierId, secret);
            return "分享连接数据被篡改，请重新获取。";
        }

        //检测连接是否超时
        Long now = (new Date()).getTime();
        if(Long.valueOf(timeout) <= now) {
            logger.info("连接timeout-{}, billId-{}, supplierId-{}超时", timeout,
                    billId, supplierId);
            return "分享连接已失效，请重新获取。";
        }
        JedisTemplate jedisTemplate = cacheManager.getJedisTemplate();
        //将secret为键放入缓存，用于判断当前连接验证码验证次数
        String checkKey = MessageSendHelper.LINK_CHECK_KEY_PREFIX + secret;

        String tl = jedisTemplate.get(checkKey);
        if(tl == null) {
            //该连接放入缓存过期时间晚于连接失效时间，确保失效后无法进入此处逻辑校验
            int keyTimeOut = (new Double(Math.ceil((Double.valueOf(timeout) - now) / Double.valueOf("1000")))).intValue();
            //该连接不在缓存中，则将该连接短信验证限制次数初始化放入缓存
            jedisTemplate.setex(checkKey, "0", keyTimeOut);
        }

        return null;
    }
}
