package com.ejianc.business.supbusiness.common.util;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.api.ISmsMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.message.vo.SmsMsgSendParam;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springside.modules.nosql.redis.JedisTemplate;

/**
 * @author CJ
 * @Description:
 * @date 2022/1/19 15:15
 */
@Component
public class MessageSendHelper {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Value("${share-link.effective-time-limit}")
    private Long effectiveTimeLimit;

    @Autowired
    private CacheManager cacheManager;

    public static final String LINK_CHECK_KEY_PREFIX = "linkCheck::";

    @Autowired
    private ISmsMessageApi smsMessageApi;

    public static final String SMS_TEMPLATE_CODE = "SMS_195335075";

    /**
     * 向租户下所有用户发送消息
     *
     * @param subject
     * @param content
     * @return
     */
    public boolean sendMsg(String subject, String content) {

        if(StringUtils.isBlank(subject) || StringUtils.isBlank(content)) {
            logger.error("向租户下所有用户发送消息失败，消息主题或消息内容为空！");
            return false;
        }

        //TODO 查询租户下所有用户Id
//        List<Long> tenantAllUids = userApi.
        String[] msgRecUserIds = new String[2];

        logger.info("向用户{}发送消息：subject-{},content-{}: ", StringUtils.join(msgRecUserIds, ","), subject, content);
        PushMsgParameter msgParameter = new PushMsgParameter();
        //消息接收人
        msgParameter.setReceivers(msgRecUserIds);
        //消息内容
        msgParameter.setContent(content);
        //消息主题
        msgParameter.setSubject(subject);
        //消息类型
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        //消息保存
        msgParameter.setSaveFlag(true);
        //消息发送人
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        //消息发送渠道
        msgParameter.setChannel(new String[]{PushMsgParameter.CHANNEL_TYPE_SYS});

        CommonResponse<String> sendResp = pushMessageApi.sendUserMsg(msgParameter);
        if(!sendResp.isSuccess()) {
            logger.error("向租户下所有用户发送消息: subject-{}, content-{} 失败，原因：{}", sendResp.getMsg());
            return false;
        }
        return true;
    }


    public String sendPhoneValidCode(String phone, String secret) {
        logger.info("手机号-{}对连接secret-{}进行短信验证！", phone, secret);
        if(StringUtils.isBlank(phone)) {
            return "无效的手机号码!";
        }
        if(StringUtils.isBlank(secret)) {
            return "发送短信失败，缺少分享链接标识!";
        }

        String key = MessageSendHelper.LINK_CHECK_KEY_PREFIX + secret;

        JedisTemplate jedisTemplate = cacheManager.getJedisTemplate();
        String tl = jedisTemplate.get(key);
        if(null == tl) {
            return "该链接已失效，请重新获取分享链接.";
        }

        Long curValidateTime = jedisTemplate.incr(key);
        if(curValidateTime >= effectiveTimeLimit) {
            return "分享链接短信验证达到次数限制，请获取新的分享链接.";
        }

        //发送短信验证消息
        SmsMsgSendParam param = new SmsMsgSendParam();
        param.setPhone(phone);
        param.setTemplateCode(SMS_TEMPLATE_CODE);
        CommonResponse<String> ts = smsMessageApi.sendMessage(param);
        logger.info("手机号-{}对连接secret-{}进行短信结果， {}", JSONObject.toJSONString(ts));

        if(!ts.isSuccess()) {
            logger.info("手机号-{}对连接secret-{}进行短信验证！", phone, secret, ts.getMsg());
            return "发送短信失败，" + ts.getMsg();
        }

        return null;
    }
}
