package com.ejianc.business.supbusiness.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.supbusiness.bean.CheckEntity;
import com.ejianc.business.supbusiness.common.util.BillShareLInkCheckHelper;
import com.ejianc.business.supbusiness.enums.CheckStateEnum;
import com.ejianc.business.supbusiness.enums.CheckSupplierSignStatusEnum;
import com.ejianc.business.supbusiness.service.ICheckService;
import com.ejianc.business.supbusiness.vo.CheckVO;
import com.ejianc.business.supbusiness.vo.DeliveryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消耗材验收单
 *
 * @author generator
 */
@Controller
@RequestMapping("check")
@Api(value = "消耗材验收单", tags = {"消耗材验收单"})
public class CheckController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private BillShareLInkCheckHelper billShareLInkCheckHelper;

    @Autowired
    private ICheckService service;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody CheckVO saveOrUpdateVO) {
        CheckEntity entity = BeanMapper.map(saveOrUpdateVO, CheckEntity.class);
        service.saveOrUpdate(entity, false);
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(@RequestParam Long id) {
        CheckEntity entity = service.selectById(id);
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (CheckVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(CheckVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryAllList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryAllList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<CheckEntity> page = service.queryPage(param, false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("查询未签字列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplierSignStatus",new Parameter(QueryParam.EQ, CheckSupplierSignStatusEnum.未签字.getCode()));

        IPage<CheckEntity> page = service.queryPage(param, false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("查询未签字列表")
    @RequestMapping(value = "/querySignedList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> querySignedList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("supplierSignStatus",new Parameter(QueryParam.EQ, CheckSupplierSignStatusEnum.已签字.getCode()));

        IPage<CheckEntity> page = service.queryPage(param, false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("协同分享查询详情")
//    @GetMapping(value = "/detailBySourceId")
    @RequestMapping(value = "/detailBySourceId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> detailBySourceId(@RequestParam(value = "id") String sourceId,
                                                    @RequestParam(value = "tl") String timeout,
                                                    @RequestParam String weakFlag,
                                                    @RequestParam String supplierTenant,
                                                    @RequestParam String secret) {
        CheckVO checkvo = service.queryCheckBySourceId(sourceId);
        if (null == checkvo) {
            return CommonResponse.error("单据在系统中不存在或已被删除！");
        }
        String checkMsg = billShareLInkCheckHelper.isShareLinkValid(timeout, sourceId, checkvo.getSupplierId()
                .toString(), weakFlag, secret, supplierTenant);
        if (StringUtils.isNotBlank(checkMsg)) {
            return CommonResponse.error(checkMsg);
        }
        return CommonResponse.success("查询成功！", checkvo);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        CommonResponse<IPage<CheckVO>> result = queryAllList(param);
        List<CheckVO> list = result.getData().getRecords();
        for (CheckVO vo : list) {
            vo.setSupplierSignStatusName( null == vo.getSupplierSignStatus() || vo.getSupplierSignStatus() == 0 ? "未签字" : "已签字");
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Check-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refMaterialCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refMaterialCheckData(@RequestParam Integer pageNumber,
                                                               @RequestParam Integer pageSize,
                                                               String condition,
                                                               String searchObject,
                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CheckEntity> page = service.queryPage(param, false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    @ApiOperation("接收验收单")
    @RequestMapping(value = "/saveCheck", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> saveCheck(HttpServletRequest request) {
        return CommonResponse.success("接收成功！", service.saveCheck(request));
    }

    @ApiOperation("验收单撤回")
    @RequestMapping(value = "/deleteCheck", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> deleteCheck(@RequestBody CheckVO vo) {
        return CommonResponse.success("接收成功！", service.deleteCheck(vo));
    }

    @ApiOperation("签字")
    @RequestMapping(value = "/saveSupplierSign", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveSupplierSign(@RequestBody CheckVO vo) {
        return CommonResponse.success("接收成功！",service.saveSupplierSign(vo));
    }
}
